# -*- coding: utf-8 -*-
# Copyright 2018 JDG <www.yunside.com>
# Create by Carmen <carmen.ling@yunside.com> at 2018/5/17

from odoo import models, fields, api
from odoo.osv import expression
from odoo.exceptions import ValidationError


class AbstractBaseData(models.AbstractModel):
    """
    基础数据基类
    """

    _name = 'jdg.abstract.base.data'
    _inherit = 'jdg.abstract.base'
    _description = u"基础数据基类"
    _order = 'number'

    name = fields.Char(string=u'名称', required=True, index=True)

    @api.multi
    @api.depends('name', 'number')
    def name_get(self):
        """
        名称显示格式：[XXX]YYY
        :return:
        """
        result = []
        for record in self:
            name = '[%s]%s' % (record.number, record.name)
            result.append((record.id, name))
        return result

    @api.model
    def name_search(self, name, args=None, offset=0, operator='ilike', limit=100, order=None, count=False,
                    name_get_uid=None):
        """
        名称模糊搜索
        :return:
        """
        args = args or []
        domain = []
        if name:
            domain = ['|', ('number', '=ilike', '%' + name + '%'), ('name', operator, name)]
            if operator in expression.NEGATIVE_TERM_OPERATORS:
                domain = ['&', '!'] + domain[1:]
        records = self.search(domain + args, limit=limit)
        return records.name_get()
