#!/usr/bin/env python
# -*- coding: utf-8 -*-
import models
import controllers
import wizard
import procedure
# import api_models
from odoo import api, SUPERUSER_ID


def pre_install_all_models(cr, registry):
    env = api.Environment(cr, SUPERUSER_ID, {})
    module_notice = env['ir.module.module'].search([('name', '=', 'jd_notice')])
    module_note = env['ir.module.module'].search([('name', '=', 'note')])

    if module_notice.state == 'uninstalled':
        module_notice.sudo().button_install()
    
    if module_note.state == 'uninstalled':
        module_note.sudo().button_install()


def pre_install_lang(cr):
    env = api.Environment(cr, SUPERUSER_ID, {})
    # 安装中文
    env['res.lang'].install_lang_zh()
    # 重设密码
    env['res.users'].browse(1)._set_password('jadedragon_init')
    # 更改翻译
    mods = env['ir.module.module'].search([('state', '=', 'installed')])
    mods.with_context(overwrite=True).update_translations('zh_CN')