package sql

import distance.util.FileUtil.writeFile
import java.io.BufferedReader
import java.io.FileReader
import java.io.IOException
import java.util.ArrayList
import kotlin.system.exitProcess

data class Farm(
        var company: String,
        var farmer: String,
        var farm: String,
        var state: String,
        var square: String,
        var structure: String,
        var density: String,
        var size_flock: String,
        var spray: String,
        var evp: String,
        var deat: String,
        var fans: String,
        var chute: String,
        var feed: String
)

data class Feed(
        var number: String,
        var parent: String,
        var name: String,
        var area: String,
        var state: String,
        var city: String,
        var subdivide: String,
        var address: String,
        var longitude: String,
        var latitude: String
)

var farmList: ArrayList<Farm> = ArrayList()
val feedList: ArrayList<Feed> = ArrayList()

private fun readFarm(filePath: String) {
    try {
        val fileReader = FileReader(filePath)
        val bufferedReader = BufferedReader(fileReader)
        bufferedReader.lineSequence().forEach {
            val splits = it.split("\t".toRegex()).toTypedArray()
            if (splits.size == 14) {
                farmList.add(Farm(splits[0], splits[1], splits[2], splits[3], splits[4], splits[5], splits[6], splits[7], splits[8], splits[9], splits[10], splits[11], splits[12], splits[13]))
            }
        }
        bufferedReader.close()
        fileReader.close()
    } catch (e: IOException) {
        e.printStackTrace()
        exitProcess(1)
    }
}

private fun readFeed(filePath: String) {
    try {
        val fileReader = FileReader(filePath)
        val bufferedReader = BufferedReader(fileReader)
        bufferedReader.lineSequence().forEach {
            val splits = it.split("\t".toRegex()).toTypedArray()
            if (splits.size == 10) {
                feedList.add(Feed(splits[0], splits[1], splits[2], splits[3], splits[4], splits[5], splits[6], splits[7], splits[8], splits[9]))
            }
        }
        bufferedReader.close()
        fileReader.close()
    } catch (e: IOException) {
        e.printStackTrace()
        exitProcess(1)
    }
}

fun main(args: Array<String>) {
    val sb: StringBuilder = StringBuilder()

    readFarm("C:\\Users\\00137030\\IdeaProjects\\HelloWorld\\src\\sql\\farm")
    for (farm in farmList) {
        sb.append("update hd_far_farm set square = ${farm.square}, structure_id = (select id from hd_far_farm_structure where name = '${farm.structure}'), density_id = (select id from hd_far_feed_density where density = ${farm.density}), size_flock = ${farm.size_flock}")
        if (farm.spray != "空") {
            sb.append(", spray_type = (select id from hd_pro_order_product_result_check where name = '${farm.spray}')")
        }
        if (farm.evp != "空") {
            sb.append(", evp_type = (select id from hd_pro_order_product_result_check where name = '${farm.evp}')")
        }
        if (farm.deat != "空") {
            sb.append(", deat_method = (select id from hd_pro_order_product_result_check where name = '${farm.deat}')")
        }
        if (farm.fans != "空") {
            sb.append(", fans_num = ${farm.fans}")
        }
        if (farm.chute != "空") {
            sb.append(", chute_type = '${farm.chute}'")
        }
        if (farm.feed != "空") {
            sb.append(", water_feed_method = (select id from hd_pro_order_product_result_check where name = '${farm.feed}')")
        }
        sb.append(" where number = '${farm.farm}';\r\n")
    }
    writeFile(sb.toString(), "C:\\Users\\00137030\\IdeaProjects\\HelloWorld\\src\\sql\\farm.sql")

    sb.setLength(0)

    readFeed("C:\\Users\\00137030\\IdeaProjects\\HelloWorld\\src\\sql\\feed")
    for (feed in feedList) {
        sb.append("update hd_m_feed_factory set state_id = (select id from res_country_state where name = '${feed.state}'), city_id = (select id from res_country_state_area where name = '${feed.city}'), home_address = '${feed.address}', longitude = ${feed.longitude}, latitude = ${feed.latitude}")
        if (feed.subdivide != "空") {
            sb.append(", subdivide_id = (select id from res_country_state_area_subdivide where name = '${feed.subdivide}')")
        }
        sb.append(" where name = '${feed.name}';\r\n")
    }
    writeFile(sb.toString(), "C:\\Users\\00137030\\IdeaProjects\\HelloWorld\\src\\sql\\feed.sql")
}
