package sql;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;


/**
 * 用于创建操作相同的大量 SQL 语句
 *
 * @author 00137030
 * @date 2022/08/25
 */
public class CreateSql {

    private static ArrayList<String> readFile(String filePath) {
        // 暂存一行字符
        String line;
        // 创建 ArrayList ，用来保存每行数据所创建的对象
        ArrayList<String> strings = new ArrayList<>();
        // 文件字符输入流
        FileReader fileReader;
        try {
            // 初始化文件字符输入流，可能存在 FileNotFoundException
            fileReader = new FileReader(filePath);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return strings;
        }
        // 缓冲区，有 readLine() 函数，方便使用
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            // 按行从文件读入，可能存在 IOException
            while ((line = bufferedReader.readLine()) != null) {
                // 每一行数据创建一个对象保存到 ArrayList 中
                strings.add(line);
            }
            // 关闭缓冲
            bufferedReader.close();
            // 关闭文件字符输入流
            fileReader.close();
        } catch (IOException e) {
            // 捕获可能出现 FileNotFoundException 和 IOException
            e.printStackTrace();
        }
        // 返回值未保存了批次存栏流水信息的 ArrayList
        return strings;
    }

    /**
     * 格式化输出 ArrayList ，每十个元素换行一次
     *
     * @param arrayList 输入 ArrayList 类型
     * @return 格式化后的字符串
     */
    private static String arrayListToString(ArrayList<String> arrayList) {
        // 使用 ArrayList 的迭代器访问其中的元素
        Iterator<String> it = arrayList.iterator();
        // ArrayList 中没有元素
        if (!it.hasNext()) {
            return "()";
        }
        // 使用 StringBuilder 保存格式化后的字符串
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        // 遍历 ArrayList
        for (; ; ) {
            // 将一个元素添加到 StringBuilder 中
            sb.append('\'').append("hd.bd.pro.boar.train,").append(it.next()).append('\'');
            // 遍历完所有元素，返回字符串
            if (!it.hasNext()) {
                return sb.append(')').toString();
            }
            // 每个元素后加上英文逗号
            sb.append(',');
        }
    }

    public static void main(String[] args) {
        String filePath = "C:\\Users\\00137030\\IdeaProjects\\HelloWorld\\src\\sql\\number";
        System.out.println("update hd_bd_bs_batch_relation_log set active='f',write_uid=1,write_date=LOCALTIMESTAMP where res_order menu_config "
                + arrayListToString(readFile(filePath)));
    }
}
