package log.data;

/**
 * 用来储存读入的数据，每一行由一个对象储存
 * 对应数据库中 hd_bd_bs_batch_relation_log 表的部分字段
 *
 * @author 00137030
 * @date 2022/08/07
 */
public class HdBdBsBatchRelationLog {
    /**
     * 批次存栏流水编号，对应表库中 number
     */
    private String number;
    /**
     * 猪只耳号，对应表中 breeding_id
     */
    private String breedingId;
    /**
     * 状态，对应表中 state_batch
     */
    private String stateBatch;

    /**
     * 全参构造器
     *
     * @param number     批次存栏流水编号
     * @param breedingId 猪只耳号
     * @param stateBatch 状态
     */
    public HdBdBsBatchRelationLog(String number, String breedingId, String stateBatch) {
        this.number = number;
        this.breedingId = breedingId;
        this.stateBatch = stateBatch;
    }

    public String getNumber() {
        return number;
    }

    public String getBreedingId() {
        return breedingId;
    }

    public String getStateBatch() {
        return stateBatch;
    }

    @Override
    public String toString() {
        return "log{" +
                "number='" + number + '\'' +
                ", breedingId='" + breedingId + '\'' +
                ", stateBatch='" + stateBatch + '\'' +
                '}';
    }
}
