package idcard;

/**
 * @author 00137030
 * @date 2022/08/01
 */
public class CheckIdCard {

    /**
     * 检测身份证号是否合法
     *
     * @param idCard 身份证号码
     * @return 检测结果
     */
    private static boolean checkIdCard(String idCard) {
        String idCardNum = idCard.trim();
        int len = idCardNum.length();
        int[] weight = {7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        char[] validate = {'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2', 'x'};
        int sum = 0;
        int mode;
        int len18 = 18, len15 = 15;
        if (len == len18) {
            for (int i = 0; i < len - 1; i++) {
                sum = sum + (idCardNum.charAt(i) - '0') * weight[i];
            }
            mode = sum % 11;
            return validate[mode] == idCardNum.charAt(17);
        } else if (len == len15) {
            System.out.println("暂未支持15位身份证号验证");
            return false;
        } else {
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println(checkIdCard("332526197610285527"));
        System.out.println(checkIdCard("332526197610284527"));
    }
}
