package groups.department;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.Collator;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GroupingDepartment {

    private static HashMap<String, ArrayList<String>> departments;

    private static void readMenus(String menuPath) {
        departments = new HashMap<>();
        String line;
        int i;
        try {
            FileReader fileReader = new FileReader(menuPath);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                // 取 菜单/显示名称 和 菜单/菜单
                String[] splits = line.trim().split("\t");
                if (splits.length == 2) {
                    if (departments.containsKey(splits[1])) {
                        departments.get(splits[1]).add(splits[0]);
                    } else {
                        departments.put(splits[1], Stream.of(splits[0]).collect(Collectors.toCollection(ArrayList::new)));
                    }
                }
            }
            bufferedReader.close();
            fileReader.close();
        } catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        readMenus("C:\\Users\\00137030\\IdeaProjects\\HelloWorld\\src\\groups\\department\\department");
        String[] departmentNames = departments.keySet().toArray(new String[0]);
        // 按简体中文排序
        Collator collator = Collator.getInstance(Locale.CHINA);
        Arrays.sort(departmentNames, collator::compare);
        ArrayList<String> numbers;
        StringBuilder sb = new StringBuilder();
        for (String department : departmentNames) {
            numbers = departments.get(department);
            sb.setLength(0);
            for (String number : numbers) {
                sb.append(";").append(number);
            }
            System.out.println(department + "\t" + department + "\t\t" + department + ";多公司;员工\t" + sb.toString().substring(1));
        }
    }
}
