package distance.util;

import distance.data.Distance;
import distance.data.Slaughter;
import distance.data.Svc;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.io.*;
import java.math.BigDecimal;
import java.util.ArrayList;

/**
 * @author 00137030
 */
public class ExcelUtil {
    public static ArrayList<Slaughter> importExcel(String fileInPath) {
        ArrayList<Slaughter> slaughterArrayList = new ArrayList<>();
        try {
            Workbook workbook = WorkbookFactory.create(new FileInputStream(new File(fileInPath)));
            Sheet sheet = workbook.getSheetAt(0);
            for (int i = 1; i <= sheet.getLastRowNum(); i++) {
                Row row = sheet.getRow(i);
                Slaughter slaughter = new Slaughter();
                slaughter.setName(row.getCell(0).getStringCellValue());
                slaughter.setHome_address(row.getCell(1).getStringCellValue());
                slaughter.setLatitude(BigDecimal.valueOf(row.getCell(2).getNumericCellValue()));
                slaughter.setLongitude(BigDecimal.valueOf(row.getCell(3).getNumericCellValue()));
                slaughterArrayList.add(slaughter);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return slaughterArrayList;
    }

    public static <T> void exportExcel(ArrayList<T> tArrayList, String fileOutPath) {
        if (tArrayList.size() == 0) {
            return;
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("距离.xlsx");
        XSSFRow row0 = sheet.createRow(0);
        int i = 1;
        XSSFRow row;
        if (tArrayList.get(0) instanceof Distance) {
            row0.createCell(0).setCellValue("id");
            row0.createCell(1).setCellValue("svc_id");
            row0.createCell(2).setCellValue("svc_name");
            row0.createCell(3).setCellValue("slaughter_id");
            row0.createCell(4).setCellValue("slaughter_name");
            row0.createCell(5).setCellValue("distance");
            row0.createCell(6).setCellValue("distance_string");
        } else if ((tArrayList.get(0) instanceof Svc) || (tArrayList.get(0) instanceof Slaughter)) {
            row0.createCell(0).setCellValue("id");
            row0.createCell(1).setCellValue("name");
            row0.createCell(2).setCellValue("home_address");
            row0.createCell(3).setCellValue("longitude");
            row0.createCell(4).setCellValue("latitude");
        }
        for (T t : tArrayList) {
            row = sheet.createRow(i++);
            if (t instanceof Distance) {
                Distance distance = (Distance) t;
                row.createCell(0).setCellValue(distance.getId());
                row.createCell(1).setCellValue(distance.getSvc_id());
                row.createCell(2).setCellValue(distance.getSvc_name());
                row.createCell(3).setCellValue(distance.getSlaughter_id());
                row.createCell(4).setCellValue(distance.getSlaughter_name());
                row.createCell(5).setCellValue(distance.getDistance());
                row.createCell(6).setCellValue(distance.getDistance_string());
            } else if (t instanceof Svc) {
                Svc svc = (Svc) t;
                row.createCell(0).setCellValue(svc.getId());
                row.createCell(1).setCellValue(svc.getName());
                row.createCell(2).setCellValue(svc.getHome_address());
                row.createCell(3).setCellValue(svc.getLongitude().toString());
                row.createCell(4).setCellValue(svc.getLatitude().toString());
            } else if (t instanceof Slaughter) {
                Slaughter slaughter = (Slaughter) t;
                row.createCell(0).setCellValue(slaughter.getId());
                row.createCell(1).setCellValue(slaughter.getName());
                row.createCell(2).setCellValue(slaughter.getHome_address());
                row.createCell(3).setCellValue(slaughter.getLongitude().toString());
                row.createCell(4).setCellValue(slaughter.getLatitude().toString());
            }
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(fileOutPath);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            workbook.write(fileOutputStream);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
