package distance.util;

import distance.data.Breeding;
import distance.data.Distance;
import distance.data.Slaughter;
import distance.data.Svc;

import java.util.ArrayList;

/**
 * @author 00137030
 */
public class CreateSqlUtil {
    public static <T> String updateSql(ArrayList<T> tArrayList) {
        if (tArrayList.size() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (T t : tArrayList) {
            if (t instanceof Svc) {
                Svc svc = (Svc) t;
                stringBuilder.append(String.format("update hd_m_svc_org set latitude=%s,longitude=%s where name='%s';\n",
                        svc.getLatitude(), svc.getLongitude(), svc.getName()));
            } else if (t instanceof Breeding) {
                Breeding breeding = (Breeding) t;
                stringBuilder.append(String.format("update hd_m_breeding_farm set latitude=%s,longitude=%s where name='%s';\n",
                        breeding.getLatitude(), breeding.getLongitude(), breeding.getName()));
            } else if (t instanceof Slaughter) {
                Slaughter slaughter = (Slaughter) t;
                stringBuilder.append(String.format("update hd_m_slaughter_house set latitude=%s,longitude=%s where name='%s';\n",
                        slaughter.getLatitude(), slaughter.getLongitude(), slaughter.getName()));
            }
        }
        return stringBuilder.toString();
    }

    public static String insertSql(ArrayList<Distance> distanceArrayList) {
        if (distanceArrayList.size() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        // 拼接 SQL
        stringBuilder.append("insert into distance(id,svc_id,svc_name,slaughter_id,slaughter_name,distance,distance_string) values\n");
        for (Distance distance : distanceArrayList) {
            stringBuilder.append(String.format("(%s,%s,'%s',%s,'%s',%s,'%s'),\n",
                    distance.getId(), distance.getSvc_id(), distance.getSvc_name(), distance.getSlaughter_id(), distance.getSlaughter_name(), distance.getDistance(), distance.getDistance_string()));
        }
        // 截去最后的逗号和换行
        stringBuilder.setLength(stringBuilder.length() - 2);
        return stringBuilder.toString();
    }
}
