package distance.mapper;

import distance.data.Svc;

import java.util.ArrayList;

/**
 * @author 00137030
 */
public interface SvcMapper {
    /**
     * 根据id查询服务部信息
     * @param id 需要查询的服务部的id
     * @return 所查询的服务部的信息
     */
    Svc selectSvc(Integer id);

    /**
     * 查询所有服务部的信息
     * @return 所查询的服务部的信息的列表
     */
    ArrayList<Svc> selectSvcs();

    /**
     * 根据id更新服务部信息
     * @param svc 需要更新的服务部
     * @return 影响的行数
     */
    Integer updateSvc(Svc svc);

    /**
     * 根据id批量更新服务部信息
     * @param svcs 需要更新的服务部的列表
     * @return 影响的行数
     */
    Integer updateSvcs(ArrayList<Svc> svcs);
}
