package distance.data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author 00137030
 */
public class Slaughter implements Serializable {
    private Integer id;
    private String name;
    private String home_address;
    private BigDecimal latitude;
    private BigDecimal longitude;

    public Slaughter() {
        this(0, "", "", new BigDecimal(0), new BigDecimal(0));
    }

    public Slaughter(Integer id, String name, String home_address, BigDecimal latitude, BigDecimal longitude) {
        this.id = id;
        this.name = name;
        this.home_address = home_address;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHome_address() {
        return home_address;
    }

    public void setHome_address(String home_address) {
        this.home_address = home_address;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public String getLocation() {
        return latitude + "," + longitude;
    }

    @Override
    public String toString() {
        return "Slaughter{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", home_address='" + home_address + '\'' +
                ", latitude=" + latitude +
                ", longitude=" + longitude +
                '}';
    }
}
