package distance.data;

import java.util.ArrayList;

/**
 * @author 00137030
 */
public class RouteMatrixResult {
    private Integer status;
    private String message;
    private ArrayList<Result> result;

    public class Result {
        DistanceResult distance;
        DurationResult duration;

        public class DistanceResult {
            String text;
            Double value;

            public String getText() {
                return text;
            }

            public Double getValue() {
                return value;
            }

            @Override
            public String toString() {
                return "DistanceResult{" +
                        "text='" + text + '\'' +
                        ", value=" + value +
                        '}';
            }
        }

        class DurationResult {
            String text;
            Double value;

            @Override
            public String toString() {
                return "DistanceResult{" +
                        "text='" + text + '\'' +
                        ", value=" + value +
                        '}';
            }
        }

        public DistanceResult getDistance() {
            return distance;
        }

        public void setDistance(DistanceResult distance) {
            this.distance = distance;
        }

        @Override
        public String toString() {
            return "Result{" +
                    "distance=" + distance +
                    ", duration=" + duration +
                    '}';
        }
    }

    public Integer getStatus() {
        return status;
    }

    public String getMessage() {
        return message;
    }

    public ArrayList<Result> getResult() {
        return result;
    }

    @Override
    public String toString() {
        return "RouteMatrixResult{" +
                "status=" + status +
                ", message='" + message + '\'' +
                ", result=" + result +
                '}';
    }
}
