package distance.amap;

import org.json.JSONObject;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;

import static distance.util.FileUtil.writeFile;
import static distance.util.HttpUtil.doGet;

public class Merge {
//    private static ArrayList<Company> companies = new ArrayList<>();
//    private static ArrayList<Slaughter> slaughters = new ArrayList<>();

    private static HashMap<String, Company> companies = new HashMap<>();
    private static HashMap<String, Slaughter> slaughters = new HashMap<>();

    private static void readLists(String filePath, String type) {
        String line;
        try {
            FileReader fileReader = new FileReader(filePath);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                String[] splits = line.trim().split("\t");
                if (splits.length == 4) {
                    if ("company".equals(type)) {
                        companies.put(splits[3], new Company(Integer.parseInt(splits[3]), splits[0], Double.parseDouble(splits[1]), Double.parseDouble(splits[2])));
                    } else if ("slaughter".equals(type)) {
                        slaughters.put(splits[3], new Slaughter(Integer.parseInt(splits[3]), splits[0], Double.parseDouble(splits[1]), Double.parseDouble(splits[2])));
                    }
                } else {
                    System.out.println("Error: " + line);
                }
            }
            bufferedReader.close();
            fileReader.close();
        } catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static int getDistance(String origins, String destinations) {
        String key = "e1364adf04e7b3ed91826479c1ac1f5c";
        String output = "json";
        String nosteps = "1";
        String strategy = "0";
        String base_url = "https://restapi.amap.com/v3/direction/driving?output=%s&nosteps=%s&strategy=%s&origin=%s&destination=%s&key=%s";
        String current_url = String.format(base_url, output, nosteps, strategy, origins, destinations, key);
        String resultString = doGet(current_url);
        if (resultString == null) {
            return -1;
        }
        JSONObject jsonObject = new JSONObject(resultString);
        if ("1".equals(jsonObject.get("status"))) {
            return Integer.parseInt(jsonObject.getJSONObject("route").getJSONArray("paths").getJSONObject(0).get("distance").toString());
        }
        return -1;
    }

//    public static void main(String[] args){
//        String s = "insert into hd_org_slaughter_distance(company_id, company_name, slaughter_id, slaughter_name, distance, distance_string) values (1421, '邱家服务部', 40115, '船山区河沙镇兰华牲畜屠宰加工食品有限公司', 0, '0公里');";
//        String[] strings = s.split("\\(|, ");
//        for(String t: strings){
//            System.out.println(t);
//        }
//        System.out.println();
//        System.out.println(strings[7]);
//        System.out.println(strings[9]);
//    }

    public static void main(String[] args) {
//        readLists("C:\\Users\\00137030\\IdeaProjects\\HelloWorld\\src\\distance\\amap\\company", "company");
//        readLists("C:\\Users\\00137030\\IdeaProjects\\HelloWorld\\src\\distance\\amap\\slaughter", "slaughter");
        String fileInPath = "src/distance/amap/insert_hd_org_slaughter_distance_fix0.sql";
        String temp;
        String tempSql;
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        int j = 0;
        int distance = 0;
        Company c;
        Slaughter s;
        try {
            FileReader fileReader = new FileReader(fileInPath);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((temp = bufferedReader.readLine()) != null) {
                if (temp.contains("0, '0公里'")) {
//                    System.out.println(i);
//                    distance = 0;
//                    System.out.println(temp);
//                    while (distance <= 0) {
//                        String[] strings = temp.split("\\(|, ");
//                        c = companies.get(strings[7]);
//                        s = slaughters.get(strings[9]);
//                        distance = getDistance(String.format("%s,%s", c.getLongitude(), c.getLatitude()), String.format("%s,%s", s.getLongitude(), s.getLatitude()));
//                        if (distance > 0) {
//                            tempSql = String.format("insert into hd_org_slaughter_distance(company_id, company_name, slaughter_id, slaughter_name, distance, distance_string) values (%s, '%s', %s, '%s', %s, '%s');\r\n", c.getId(), c.getName(), s.getId(), s.getName(), distance, (distance / 1000) + "公里");
//                            System.out.println(tempSql);
//                            stringBuilder.append(tempSql);
//                        }
//                    }
                    j++;
                } else {
                    stringBuilder.append(temp).append("\r\n");
                }
                i++;
//                if (i == 348600) {
//                    break;
//                    writeFile(stringBuilder.toString(), "src/distance/amap/insert_hd_org_slaughter_distance_fix0.sql");
//                    stringBuilder.setLength(0);
//                }
            }
            bufferedReader.close();
            fileReader.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(i);
        System.out.println(j);

        String fileOutPath = "src/distance/amap/insert_hd_org_slaughter_distance0.sql";
        try {
            FileWriter fileWriter = new FileWriter(fileOutPath, false);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(stringBuilder.toString());
            bufferedWriter.flush();
            bufferedWriter.close();
            fileWriter.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
