package distance.amap;

import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

import static distance.util.FileUtil.writeFile;
import static distance.util.HttpUtil.doGet;

public class Main4 {
    private static ArrayList<Company> companies = new ArrayList<>();
    private static ArrayList<Slaughter> slaughters = new ArrayList<>();

    private static void readLists(String filePath, String type) {
        String line;
        try {
            FileReader fileReader = new FileReader(filePath);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                String[] splits = line.trim().split("\t");
                if (splits.length == 4) {
                    if ("company".equals(type)) {
                        companies.add(new Company(Integer.parseInt(splits[3]), splits[0], Double.parseDouble(splits[1]), Double.parseDouble(splits[2])));
                    } else if ("slaughter".equals(type)) {
                        slaughters.add(new Slaughter(Integer.parseInt(splits[3]), splits[0], Double.parseDouble(splits[1]), Double.parseDouble(splits[2])));
                    }
                } else {
                    System.out.println("Error: " + line);
                }
            }
            bufferedReader.close();
            fileReader.close();
        } catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /**
     * 调用高德地图API获取两个地点之间的驾车行驶距离
     * @param origins 出发点，格式为：经度,纬度
     * @param destinations 目的地，格式为：经度,纬度
     * @return 行驶距离，单位：米
     * @throws Exception 自定义异常，便于记录错误原因
     */
    private static int getDistance(String origins, String destinations) throws Exception {
        String key = "e1364adf04e7b3ed91826479c1ac1f5c"; //用户唯一标识
        String output = "json";//返回数据格式类型，可选JSON和XML
        String nosteps = "1"; //当取值为0时，steps字段内容正常返回导航路段；当取值为1时，steps字段内容为空
        String strategy = "0"; //驾车选择策略，0：速度优先，1，费用优先；2，距离优先；
        String base_url = "https://restapi.amap.com/v3/direction/driving?output=%s&nosteps=%s&strategy=%s&origin=%s&destination=%s&key=%s";
        String current_url = String.format(base_url, output, nosteps, strategy, origins, destinations, key);
        String resultString = doGet(current_url);
        if (resultString == null) {
            throw new Exception("resultString为null");
        }
        JSONObject jsonObject = new JSONObject(resultString);
        if ("1".equals(jsonObject.get("status"))) {
            int distance = Integer.parseInt(jsonObject.getJSONObject("route").getJSONArray("paths").getJSONObject(0).get("distance").toString());
            if (distance <= 0) {
                throw new Exception("distance不大于0");
            }
            return distance;
        }
        throw new Exception("status不为1");
    }

    public static void main(String[] args) throws InterruptedException {
//        Thread.sleep(7 * 3600 * 1000);
        readLists("C:\\Users\\00137030\\IdeaProjects\\HelloWorld\\src\\distance\\amap\\company", "company");
        readLists("C:\\Users\\00137030\\IdeaProjects\\HelloWorld\\src\\distance\\amap\\slaughter", "slaughter");
        String output = "src/distance/amap/insert_hd_org_slaughter_distance60.sql";
        StringBuilder builder = new StringBuilder();
        String temp;
        Company c;
        Slaughter s;
        for (int i = 490; i < companies.size(); i++) {
            c = companies.get(i);
            System.out.println("companies[" + i + "]");
            for (int j = 0; j < slaughters.size(); j++) {
                s = slaughters.get(j);
                System.out.println("slaughters[" + j + "]");
                try {
                    int distance = getDistance(String.format("%s,%s", c.getLongitude(), c.getLatitude()), String.format("%s,%s", s.getLongitude(), s.getLatitude()));
                    temp = String.format("insert into hd_org_slaughter_distance(company_id, company_name, slaughter_id, slaughter_name, distance, distance_string) values (%s, '%s', %s, '%s', %s, '%s');\r\n", c.getId(), c.getName(), s.getId(), s.getName(), distance, (distance / 1000) + "公里");
                    System.out.println(temp);
                    builder.append(temp);
                } catch (Exception e) {
                    writeFile(builder.toString(), output);
                    builder.setLength(0);
                    System.out.println("Error: " + c.getName() + "\t" + s.getName());
                    e.printStackTrace();
                    j--;
                }
            }
            writeFile(builder.toString(), output);
            builder.setLength(0);
        }
    }
}
