package distance.amap;

import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

import static distance.util.FileUtil.writeFile;
import static distance.util.HttpUtil.doGet;

public class Main1 {
    private static ArrayList<Company> companies = new ArrayList<>();
    private static ArrayList<Slaughter> slaughters = new ArrayList<>();

    private static void readLists(String filePath, String type) {
        String line;
        try {
            FileReader fileReader = new FileReader(filePath);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                String[] splits = line.trim().split("\t");
                if (splits.length == 4) {
                    if ("company".equals(type)) {
                        companies.add(new Company(Integer.parseInt(splits[3]), splits[0], Double.parseDouble(splits[1]), Double.parseDouble(splits[2])));
                    } else if ("slaughter".equals(type)) {
                        slaughters.add(new Slaughter(Integer.parseInt(splits[3]), splits[0], Double.parseDouble(splits[1]), Double.parseDouble(splits[2])));
                    }
                } else {
                    System.out.println("Error: " + line);
                }
            }
            bufferedReader.close();
            fileReader.close();
        } catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static int getDistance(String origins, String destinations) throws Exception {
        String key = "e1364adf04e7b3ed91826479c1ac1f5c";
        String output = "json";
        String nosteps = "1";
        String strategy = "0";
        String base_url = "https://restapi.amap.com/v3/direction/driving?output=%s&nosteps=%s&strategy=%s&origin=%s&destination=%s&key=%s";
        String current_url = String.format(base_url, output, nosteps, strategy, origins, destinations, key);
        String resultString = doGet(current_url);
        if (resultString == null) {
            throw new Exception("resultString为null");
        }
        JSONObject jsonObject = new JSONObject(resultString);
        if ("1".equals(jsonObject.get("status"))) {
            int distance = Integer.parseInt(jsonObject.getJSONObject("route").getJSONArray("paths").getJSONObject(0).get("distance").toString());
            if (distance <= 0) {
                throw new Exception("distance不大于0");
            }
            return distance;
        }
        throw new Exception("status不为1");
    }

    public static void main(String[] args) {
        readLists("C:\\Users\\00137030\\IdeaProjects\\HelloWorld\\src\\distance\\amap\\company", "company");
        readLists("C:\\Users\\00137030\\IdeaProjects\\HelloWorld\\src\\distance\\amap\\slaughter", "slaughter");
        String output = "src/distance/amap/insert_hd_org_slaughter_distance1.sql";
        StringBuilder builder = new StringBuilder();
        String temp;
        Company c;
        Slaughter s;
        for (int i = 100; i < 150; i++) {
            c = companies.get(i);
            System.out.println("companies[" + i + "]");
            for (int j = 0; j < slaughters.size(); j++) {
                s = slaughters.get(j);
                System.out.println("slaughters[" + j + "]");
                try {
                    int distance = getDistance(String.format("%s,%s", c.getLongitude(), c.getLatitude()), String.format("%s,%s", s.getLongitude(), s.getLatitude()));
                    temp = String.format("insert into hd_org_slaughter_distance(company_id, company_name, slaughter_id, slaughter_name, distance, distance_string) values (%s, '%s', %s, '%s', %s, '%s');\r\n", c.getId(), c.getName(), s.getId(), s.getName(), distance, (distance / 1000) + "公里");
                    System.out.println(temp);
                    builder.append(temp);
                } catch (Exception e) {
                    writeFile(builder.toString(), output);
                    builder.setLength(0);
                    System.out.println("Error: " + c.getName() + "\t" + s.getName());
                    e.printStackTrace();
                    j--;
                }
            }
            writeFile(builder.toString(), output);
            builder.setLength(0);
        }
    }
}
