package distance;

import com.google.gson.Gson;
import distance.data.*;
import distance.mapper.DistanceMapper;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

import java.io.*;
import java.util.ArrayList;

import static distance.util.CastUtil.castArrayList;
import static distance.util.CreateSqlUtil.*;
import static distance.util.ExcelUtil.exportExcel;
import static distance.util.FileUtil.writeFile;
import static distance.util.HttpUtil.doGet;
import static distance.util.ObjectSerializableUtil.*;

/**
 * @author 00137030
 * @date 2022/10/10
 */
public class DistanceCalculation {

    private static String[] aks = {"C1a18a5c3b7dd7bdcbc1b", "qbiOAtygEIEObG7rh6bMPdmztVBWll4a", "UduNT7TBcaoXMDSRhWqoA4GIKp135qfO"};

//    private static String[] slaughter_names = {"资源县康态肉联食品有限公司","资源县康态肉联食品有限公司","珠海市食品公司肉联厂","重庆市潼南区东安肉类食品有限公司","重庆市松辉农业发展有限公司","重庆市昌大食品有限公司","重庆白市驿板鸭食品有限责任公司","钟祥盘龙肉类加工有限公司","钟山县食品公司","中山市长禾肉联加工有限公司","中山市小榄镇食品有限公司","中山市小榄镇食品有限公司","中山市坦洲镇肉联厂","中山市坦洲镇肉联厂","中山市神湾镇龙发食品有限公司","中山市神湾镇龙发食品有限公司","正源肉食品有限公司","正源肉食品有限公司","浙江青莲食品股份有限公司","肇庆市肉类联合加工厂","肇庆市大旺开发区生猪定点屠宰场","昭平县安丰牲畜屠宰有限责任公司","昭平县安丰牲畜屠宰有限责任公司","云南森汇食品有限责任公司","云南吉源食品有限公司","粤海食品(佛山)有限公司","粤海食品(佛山)有限公司","粤海食品(佛山)有限公司","远安县远华食品有限责任公司","于都县龙祥食品有限公司","应城市德源肉联有限公司","宜春佳绿肉食品有限公司","宜城襄大食品有限公司","宜昌双汇食品有限责任公司","宜昌三欣食品有限责任公司","盐城冠全食品有限公司","宣威市宣润食品有限公司","徐州凯佳食品有限公司","盱眙润林农牧有限公司","宿州雨润肉联厂","宿迁威海肉品有限公司","兴安县食品公司","鑫源屠宰场","新余绿园肉类食品有限公司","欣康绿食品","湘峰屠宰场","武平粱牧食品有限公司","武汉市康顺肉类食品有限公司","武汉市合庆食品有限公司","武安市豚之源生猪屠宰有限公司","梧州市龙圩区龙城家畜定点屠宰厂","无锡天鹏食品有限公司","无为市康宁科技食品有限公司","翁源县食品公司益民肉联厂","拓东肉食水产有限公司","铜鼓县生猪定点屠宰场","遂宁市京富食品有限公司","苏州吴江市食品有限公司","四川盛龙食品有限公司","四川锦辰食品有限公司","神农肉业","神农肉业","神农肉业","深圳市中龙食品有限公司","深圳市中龙食品有限公司","山东郯润生态食品有限公司","三亚益民肉联实业有限公司","三旺实业有限公司","清远市万安食品有限公司","清远市万安食品有限公司","清远市安贤食品有限公司","祁阳县浯溪肉类食品有限公司","平和县南山生猪定点屠宰场","平昌县德源食品有限公司","南通市海门区兴旺肉制品有限公司","南宁市邕宾城关家畜定点屠宰场","南充市高坪区南丰现代农业开发有限公司","南部县金瑞食品有限责任公司","绵阳市四汇食品有限公司","绵阳市四汇食品有限公司","绵阳市久诚食品有限公司","绵阳市久诚食品有限公司","绵阳市宏尔食品有限公司","绵阳柒鑫食品有限公司","茅山肉联厂","泸西县宏达畜牧供销有限公司","娄底市庆阳牧业食品有限公司","柳城县牲畜定点屠宰场","临桂县城生猪定点屠宰场","临桂县城生猪定点屠宰场","荔浦保联食品有限公司","老河口市润通食品有限公司","蓝山县肉食品公司","来安县晟瑞食品有限公司","昆山市定点屠宰加工中心有限公司","昆山市定点屠宰加工中心有限公司","昆山市定点屠宰加工中心有限公司","昆明市西山区食品有限公司生猪定点屠宰分公司","昆明市西山区食品有限公司生猪定点屠宰分公司","凯里经济开发区宏大源农产品配送有限公司","荆州市正鼎屠宰场","荆州市丰泽园农业公司","江阴澄记肉食股份有限公司","江西思倍得农牧集团有限公司生猪屠宰场","上高县宝龙食品有限公司","江西龙汇食品有限公司","江西程明食品有限公司","江苏联大食品有限公司","江门市蓬江区杜阮镇广润肉联厂","江门市广利肉类食品有限公司","惠水县三都镇兴旺屠宰场","汇弘实业有限公司","黄州区旺兴肉联有限公司","淮安温氏晶诚食品有限公司","淮安双汇食品有限公司","淮安双汇食品有限公司","淮安市超越工贸有限公司","湖南省新红叶牧业食品有限公司","湖北三汇肉联有限公司","湖北绿生畜牧科技发展有限公司","湖北佳农食品有限公司","湖北虹美食品有限公司","洪湖汇裕食品有限公司","红星盛业食品股份有限公司","湖南恒惠食品有限公司","湖南恒惠食品有限公司","贺州市正旭食品有限公司","河池市宜州区永福畜禽交易有限公司","合肥鲜利食品有限责任公司","合肥市板桥生猪定点屠宰厂","海南省东方市食品公司","海口市澄迈县瑞今屠宰场","桂林玉昌食品有限公司","桂林甲山西环屠宰场","贵州巨农肉业发展有限公司","贵州巨农肉业发展有限公司","广州市番禺食品有限公司大石分公司","广州皇上皇集团公司孔旺记肉业分公司","广州皇上皇集团公司孔旺记肉业分公司","广州番禺食品有限公司","广西新又鲜畜禽有限公司","广西三江县红日食品责任公司","广西睿盛农牧有限公司","广西容县天天食品有限公司城区屠宰场","广西陆富食品有限公司","广西荔浦县食品有限责任公司荔城镇屠宰场","广联屠宰场","广东颐丰食品股份有限公司","广东颐丰食品股份有限公司","广东颐丰食品股份有限公司","广东省新兴县食品有限公司","广东春浩食品集团有限公司","赣州市万丰食品有限公司","赣州市南康区祥龙生猪定点屠宰场有限公司","佛山市顺德区德为食品有限公司","佛山市顺德区德容食品有限公司","佛山市食品有限公司肉类联合加工厂","佛山市禅城区储备粮油有限公司","佛山市禅城区储备粮油有限公司","番禺食品厂大石4A屠宰场","鄂州市宏昌食品有限公司","东莞市中心定点屠宰场股份有限公司","东莞市中心定点屠宰场股份有限公司","东莞市中堂中心屠场","东莞市塘厦食品公司","东莞市生猪定点屠宰场","东莞市生利食品有限公司（中堂屠宰场）","东莞市生利食品有限公司（中堂屠宰场）","东莞市生利食品有限公司（中堂屠宰场）","东莞市生利食品有限公司（中堂屠宰场）","德州明敬食品有限公司","德州明敬食品有限公司","当阳市翔鹤食品有限责任公司","丹徒区益康屠宰加工有限公司","大冶隆庆肉类加工有限公司","常熟市食品公司辛庄分公司","册亨县荣顺生猪定点屠宰场","苍南县华统食品有限公司","白沙生猪定点屠宰场","巴中市兴旺食品有限公司","安岳县友六屠宰场","安远县优源牧业有限公司","安远县华欣生猪屠宰有限公司","安远县华欣生猪屠宰有限公司","安徽省芜湖市民生屠宰场"};
//    private static String[] slaughter_addresses = {"广西壮族自治区桂林市资源县301省道西30米","广西壮族自治区桂林市资源县301省道西30米","广东省珠海市香洲区前山街道翠珠路19号","重庆市重庆市潼南区梓潼街道办事处东安大道248号","重庆市重庆市巴南区南彭街道清风桥村石塔岗组","重庆市重庆市荣昌区重庆市荣昌区双河街道白玉社区二社","重庆市重庆市九龙坡区白市驿镇白新街92号","湖北省荆门市钟祥市南湖原种场工业园区西环二路49号","广西壮族自治区贺州市钟山县钟山镇周屋厂","广东省中山市中山市沙溪镇秀山村","广东省中山市小榄镇广东省中山市海威路与威雄路交叉口南140米","广东省中山市中山市小榄镇","广东省中山市坦洲镇广东省中山市联胜小学东侧约130米","广东省中山市坦洲镇广东省中山市联中路与宜东街路交叉口西120米","广东省中山市神湾镇广东省中山市神湾大道南177号神湾镇","广东省中山市神湾镇广东省中山市神湾大道南177号神湾镇","湖南省永州市零陵区河西工业园","湖南省永州市零陵区河西工业园","浙江省嘉兴市海盐镇望海街道凤凰路18号","广东省肇庆市端州区黄岗街道端州区一路羚山路北侧","广东省肇庆市四会市大旺开发区","广西壮族自治区贺州市昭平县昭平镇富裕村上段小组","广西壮族自治区贺州市昭平县昭平镇富裕村上段小组","云南省昆明嵩明县嵩明县146乡道与嘉玲中路交叉口北220米","云南省红河哈尼族自治州红河哈尼族自治州弥勒市红河哈尼族自治州弥勒市G357与双桥路交叉口到东北方向575米","广东省佛山市南海区广东省佛山市南海区狮山镇长兴路2号","广东省佛山市大沥镇佛山市南海区大沥镇长虹岭工业园长兴路2号","广东省佛山市南海区广东省佛山市南海区长岗北路","湖北省宜昌市远安县湖北省宜昌市远安县花林寺镇三孔村2组","江西省赣州于都罗坳镇上欧工业园振兴大道九丰新能源往下100米","湖北省孝感市应城市长江埠镇苏台村166号","江西省宜春市袁州区春风路与宜寺路交叉口西280米","湖北省襄阳市宜城市楚都大道625号","湖北省宜昌市西陵区湖北省宜昌市西陵区东山二路与港窑路交叉口","湖北省宜昌市伍家岗区湖北省宜昌市伍家岗区金巴岭路9号","江苏省盐城市大丰区白驹镇通榆路98号","云南省曲靖宣威云南省曲靖市宣威市东过境公路附件","江苏省徐州市丰县凤翔路东","江苏省淮安市盱眙县江苏省淮安市盱眙县工二路与创业路交叉口北200米","安徽省宿州市埇桥区纺织路2号","江苏省宿迁市沭阳县沭阳县威海路南50米","广西壮族自治区桂林市兴安县兴桂中路212号","广西壮族自治区柳州市鹿寨县鹿新路与创园二路交叉口南120米","江西省新余市渝水区新余市渝水区珠珊镇板桥工业平台","四川省成都市彭州市物流大道499号","湖南省株洲市天元区长江南路与颐康路交叉口西140米","福建省龙岩市武平县滨河东路18号","湖北省武汉市江夏区廖家村107国道旁","湖北省武汉蔡甸区湖北省武汉市蔡甸区蔡甸街蔡张路25号","河北省邯郸市武安市新武公路西10米红山寺路口","广西壮族自治区梧州龙圩区乌海线与念社线交叉路口往东约110米","江苏省无锡市梁溪区广益街道","安徽省芜湖市无为市经济开发区经四路","广东省韶关市翁源县龙仙镇建设二路","湖南省衡阳市祁东县洪桥镇大桥路3号","江西宜春铜鼓县江西省宜春市铜鼓县温泉镇241省道东50米","四川遂宁安居区四川省遂宁市安居区琼江中路3号","江苏省苏州市吴江区吴江区松陵镇北门路5号","四川德阳广汉市广汉市三星堆镇楠林村二社","四川省南充市高坪区四川省南充市高坪区都京工业园南段","云南省昆明市官渡区拓翔路138号","云南省昆明市官渡区拓翔路138号","云南省昆明市官渡区拓翔路138号","广东省深圳市坪山区坪山区龙田街道龙兴北路135号","广东省深圳市坪山区坪山区龙田街道龙兴北路135号","山东省临沂市郯城县山东省临沂市郯城县庙山镇驻地西2000米","海南省三亚市海螺村新建路20号","湖南省湘潭市韶山市永义乡白玉村支部委员会","广东省清远市清城区大有村委月岗水利枢纽便道旁","广东省清远市清城区横荷街道大有村委","广东省清远市清城区飞来峡镇社区","湖南永州市祁阳市祁阳市G322（衡友线）","福建省漳州平和县天河路与文锦路交叉路口往南270米","四川省巴中市平昌县平昌县江口镇小角楼大道109号","江苏省南通市海门区粤海路718号","广西壮族自治区南宁市邕宁区八尺江路316号","四川省南充市高坪区长乐镇石板坡村3组","四川省南充市南部县蜀北街道办事处松云洞村四社","四川省绵阳市涪城区高新区高新普明街道五七五军用公路松林山村","四川省绵阳市涪城区高新区高新普明街道五七五军用公路松林山村","四川绵阳江油市江油市绵阳阿里乐米食品科技有限公司东北侧食品公司","四川绵阳江油市江油市绵阳阿里乐米食品科技有限公司东北侧食品公司","四川绵阳涪城区涪城区宝灯街与宝马 街交叉口西300米","四川绵阳安州区绵阳市安州区绵阳柒鑫食品有限公司","广东省广州市白云区江高镇肉联街8号","云南省红河哈尼族彝族自治州泸西县飞机场公路管理所东南侧130米","湖南娄底市娄星区湖南省娄底市娄星区湘阳街2121号","广西壮族自治区柳州市柳城县大埔镇附近","广西壮族自治区桂林市临桂区二塘站附近","广西壮族自治区桂林市临桂区二塘站附近","广西壮族自治区桂林市荔浦县荔浦市安和药业有限公司西南食品公司","湖北襄阳老河口湖北省襄阳市老河口市赞阳街道黄营六组","湖南省永州市蓝山县塔峰路19号","安徽省滁州市来安县安徽省滁州市来安县创新路24号","江苏省苏州市昆山市昆山市张浦镇白米村紫禁路东侧","江苏省苏州市张浦镇昆山市张浦镇白米村紫禁路东侧","江苏省苏州市张浦镇昆山市张浦镇白米村紫禁路东侧","云南昆明西山区云南省昆明市西山区海口街道","云南昆明西山区云南省昆明市西山区海口街道","贵州省黔东南苗族侗族自治州凯里市镰刀湾路北40米","湖北省荆州市荆州区荆州大道86号","湖北省荆州市江陵县经济开发区楚江大道11号","江苏省无锡市江阴市江阴市西利路167号","江西省吉安市吉州区袁塘路","江西宜春市上高县上高县塔下乡上新村","江西吉安吉安凤凰大道与先歌大道交叉路口往西北约60米","江西南昌市新建区南昌市新建区麦梅段附近","江苏省宜兴 市徐舍镇江苏省宜兴市徐舍镇民惠路1号","广东省江门市蓬江区松园大道与江杜东路交叉口北180米","广东省江门市蓬江区蓬江区荷塘镇中兴三路58号","贵州省黔南布依族苗族自治州惠水县贵州省黔南布依族苗族自治州惠水县三都街与212国道交叉口北120米","湖南省湘潭市韶山市208省道南50米","湖北省黄冈市黄州区南湖街道南湖工业园","江苏省淮安市盱眙县331省道与维漫线交叉口西500米","江苏淮安市淮阴区江苏省淮安市淮阴区嫩江鲁127号","江苏省淮安市淮阴区江苏省淮安市淮阴区嫩江鲁127号","江苏省淮安市涟水县涟水县涟城镇香樟路1号","湖南省娄底市双峰县永丰镇茅坪村六组","湖北省咸宁市通城县马港镇何婆桥村七组","湖北仙桃湖北省仙桃市G318","湖北黄冈黄州区湖北省黄冈市黄州区南湖街道南湖工业园","湖北荆门东宝区荆门市东宝区牌楼镇牌楼村五组","湖北省荆州市洪湖市洪湖市茅江大道45号","湖南省长沙市雨花区荷新路与比亚迪路交叉口西200米","湖南省永州市水滩区湖南省永州市冷水滩区凤凰园恒惠食品有限公司","湖南省永州市水滩区湖南省永州市冷水滩区凤凰园恒惠食品有限公司","广西壮族自治区贺州市八步区八步区贺街镇寿峰村3号","广西壮族自治区河池市宜州区金宜大道康宁路","安徽省亳州市利辛县安徽省亳州市利辛县世纪大道与子胥大道交叉路口往东约120米","安徽省合肥市庐阳区安徽省合肥市庐阳区-涡阳路北环阳光东北侧约170米","海南省省直辖县级行政区划东方市二环北路134号","海南省省直辖县级行政区划澄迈县大丰镇华侨农场儒杨村北侧","广西壮族自治区桂林市雁山区雁山区奇峰路","广西壮族自治区桂林市秀峰区秀峰区敦睦村567号","贵州省贵阳市花溪区贵州省贵阳市花溪区清溪街道办事处陈亮村关口牛场坡","贵州省贵阳市花溪区贵州省贵阳市花溪区清溪街道办事处陈亮村关口牛场坡","广东省广州市番禺区大石镇","广东省广州市白云区茅山东北街21号","广东省广州市白云区茅山东北街21号","广东省广州市番禺区广州市番禺区桥街大北路仓边大街33号","广西壮族自治区南宁西乡塘区石埠镇颜屋村","广西壮族自治区柳州市三江侗族自治县广成线与福学路交叉路口往北约240米","广西壮族自治区玉林市博白县旺茂镇八廊五金交电东北150米","广西壮族自治区玉林容县保子岭桥与376县道交叉口东北150米","广西壮族自治区贺州市富川瑶族自治县富川瑶族自治县716县道路口1公里","广西壮族自治区桂林市荔浦市荔桂路与荔新巷交叉口东北420米","湖南省长沙市长沙县G4京港澳高速与杨梓冲枢纽交叉口西100米","广东省中山市西区广东省中山市西区街道港隆中路1号","广东省中山市东省中山市港隆中路与沙港西路交叉口西北140米","广东省中山市西区广东省中山市西区街道港隆中路1号","广东省云浮市新兴县新城镇大南路122号","广东省江门市开平市开平市三联管区敢鱼嘴(近肉联厂)","江西赣州经济开发区金龙路16号","江西赣州南康京珠线","广东省佛山市顺德区广东省佛山市顺德区乐从镇乐从社区藤湖路101号之六","广东省佛山市顺德区容桂街道小黄圃居委会创业路4号之二","广东省佛山市禅城区禅城区南庄镇溶洲村委会永丰村","广东省佛山市禅城区人民西路5号","广东省佛山市禅城区人民西路5号","广东省广州市番禺区茶庄园路","湖北省鄂州市鄂城区杨叶镇杨叶大道211号","广东省东莞市万江区广东省东莞市小享滘围北路1号","广东省东莞市东莞市万江街道小享社区","广东省东莞市东莞市中堂珍三涌管理区","广东省东莞市塘厦镇石潭布致富街1号","广东省东莞市建安路振安科技园西侧约200米","广东省东莞市中堂镇南潢路三涌段42号","广东省东莞市中堂镇南潢路三涌段42号","广东省东莞市中堂镇南潢路三涌段42号","广东省东莞市中堂镇南潢路三涌段42号","山东德州市德城区山东省德州市德城区黄河涯镇三十里铺","山东德州市德城区山东省德州市德城区黄河涯镇三十里铺","湖北当阳市湖北省当阳市友谊路1巷","江苏省镇江市丹徒区上党镇","湖北黄石大冶市湖北省黄石市大冶市陈贵镇陈贵大道21号","江苏省苏州市常熟市杨中南路与项泾桥头路交叉口东北140米","贵州省黔西南布依族苗族自治州册亨县者楼镇坡荣路（浪沙农场处）","江苏省温州市苍南县藻溪镇魁桥村468号","湖南省衡阳市耒阳市泗门洲镇白沙村","四川省巴中市巴州区四川省巴中市巴州区曾口镇方山寨村一社","四川省资阳市安岳县四川省资阳市安岳县龙台镇丝绸社区3组","江西省赣州市安远县天心镇高塅岗背11号","江西省赣州市安远县版石镇工业园(版石高速入口加油站旁边)","江西省赣州市安远县版石镇工业园(版石高速入口加油站旁边)","安徽省芜湖市南陵县G205辅路"};

    private static String[] breeding_names = {"崇左岜佶CS场", "射阳博鸿CS场", "沙洋沈集PS场", "绥宁红岩PS场", "田阳五村PS场", "凤凰落潮井PS场", "沙洋曾集PS场", "全州邓家埠PS场", "田阳雷圩CS场", "庆元竹口CS场", "荆门团林铺PS场", "镇雄果珠PS场", "六安独山GGP场", "乐安龚坊GGP场", "陆良大莫古PS场", "开化桐村PS场", "梅州五华PS场", "衡南向阳桥PS场", "巴马燕洞CS场", "汨罗古培PS场", "凤阳白路塘PC场", "祥云下庄PS场", "郑墩永润PC场", "彭州桂花PS场", "宿松香玲CS场", "罗定太平PS场", "分宜操场CS场", "崇左那坎公猪站", "大关服务部GDU", "桦川新城PC场", "崇左渠西CS场二期", "藤县服务部GDU", "于都服务部GDU", "冠县服务部GDU", "小海服务部GDU", "定南天九PS场", "永新嘉华PS场", "万载三兴CS场", "望奎后三CS场", "泗阳南刘集CS场", "翠屏金秋湖PS场", "金溪左坊CS场", "金溪石门CS场", "桦川梨丰CS场", "利辛服务部GDU", "山阴古城镇CS场", "泰和灌溪PS场", "兴宾良塘PS场", "游仙景维PS场", "武宁澧溪PS二场", "赣县服务部GDU", "桂阳服务部GDU", "金溪CS二场GDU", "儋州服务部GDU", "蒙城楚村CS场", "平昌服务部GDU", "始兴马市PS场", "松滋服务部GDU", "孟良崮服务部GDU", "望奎南五PS场", "大祥蔡锷PS场", "桐庐富春江GGP场", "洪雅将军PS场", "永新里田PS场", "龙台稻花PS场", "耒阳坛下PS场", "镇雄坪上GP场", "泗县刘圩PS场", "麦岭服务部GDU", "寿县服务部GDU", "埇桥服务部GDU", "东台服务部GDU", "双定服务部GDU", "响水服务部GDU", "三都服务部GDU", "宿松香玲GDU场", "前当堡服务部GDU", "上高田心PC场", "崇左渠茗PS场", "怀远服务部GDU", "嘉禾普满PS场", "仲村服务部GDU", "淮阴服务部GDU", "中洲服务部GDU", "会泽服务部GDU", "进贤服务部GDU", "冷水滩普利桥PS场", "上高泗溪PS场", "巴马所略PS场", "藤县天平PS场", "柳城马山PS场", "北镇服务部GDU", "封丘陈固GDU场", "新沂服务部GDU", "马山服务部GDU", "平原PS场", "开平苍城PS场", "常宁西岭PS场", "游仙信义PC场", "游仙魏城PS场", "新丰沙田GGP场", "涡阳义门PS场", "霍邱白莲PS场", "郯城服务部GDU", "巴州服务部GDU", "镇雄坪上PS场-作废", "兰陵服务部GDU", "兰山服务部GDU", "平原服务部GDU", "大余浮江PS场", "大方兴隆PS场", "枝江服务部GDU", "梓潼自强GP场", "赤壁服务部GDU", "巴马CS场GDU", "盱眙服务部GDU", "宿城服务部GDU", "巴马岩延PC场", "山阴薛圐圙GDU场", "英红服务部GDU", "新桥头服务部GDU", "廉江服务部GDU", "钟山服务部GDU", "陂头正河PS场", "望奎CS场GDU", "渝水高丰PS场", "盈江支那PS场", "兴义安龙PS场", "武宁澧溪PS场", "温岭滨海PS场", "南迳马安CS场GDU", "南迳大庄CS场GDU", "庆元竹口GDU场", "武鸣服务部GDU", "掇刀PS场（作废）", "祥云CS场GDU", "射阳临海PS场", "遂川碧洲PS场", "乳源一六PS场", "曲江枫湾PS场", "南迳玉舍PS场", "南迳茅山PS场", "梅县南口PS场", "兰考仪封PC场", "陂头李家洞PS场", "游仙信义CS场", "大丰服务部GDU", "岑溪服务部GDU", "草庙服务部GDU", "沾益服务部GDU", "威信服务部GDU", "全州服务部GDU", "禹州苌庄PS场", "泗阳爱园PC场", "吉安永阳PS场", "淮南潘集PS场", "惠城横沥PS场", "汉川庙头PS场", "德保CS场GDU", "南迳甘坑PS场", "阜宁罗桥PS场", "扶沟吕潭PS场", "睢宁姚集PS场", "萧县陆阳GDU场", "零陵服务部GDU", "陆屋服务部GDU", "江油服务部GDU", "祥云刘厂CS场GDU", "峨山元山PS场", "东台弶港PS场", "大庆林源PS场", "丹江口蒿坪PS场", "大关高桥GGP场", "安远龙布PS场", "崇左渠西CS场", "凤台服务部GDU", "营山服务部GDU", "晴隆服务部GDU", "白沙服务部GDU", "莒县安庄GDU场", "靖西禄峒PS场", "武汉木兰PC场", "封丘陈固CS场", "浑源南榆林PS场", "济源大庄PS场", "枣阳服务部GDU", "坪石服务部GDU", "凤阳服务部GDU", "肥乡服务部GDU", "新政服务部GDU", "公安服务部GDU", "上高徐家渡PS场", "宿城罗圩PS场", "金溪CS场GDU", "宜昌当阳CS场", "田东服务部GDU", "吉安服务部GDU", "扶绥服务部GDU", "武胜服务部GDU", "青州谭坊PS场", "分宜云阳PS场", "凤阳CS场GDU", "老河口服务部GDU", "阜宁服务部GDU", "恭城服务部GDU", "兰山CS场GDU", "通山服务部GDU", "洞口服务部GDU", "三华PS场", "崇左左州PS三场", "三阳服务部GDU", "枣阳PS场", "钟祥服务部GDU", "嘉禾服务部GDU", "寿光台头PS场", "济源轵城PS场", "崇左左州PS四场", "青疃服务部GDU", "平果服务部GDU", "西充服务部GDU", "分宜CS场GDU", "先锋服务部GDU", "六安服务部GDU", "当阳服务部GDU", "汨罗服务部GDU", "阜南服务部GDU", "滨海服务部GDU", "威县服务部GDU", "安仁服务部GDU", "大槐服务部GDU", "荥阳CS场GDU", "隆安古潭PS场", "霍邱周集CS场", "莒县库山PS场", "翠屏中元PS场", "分宜洋江CS场", "乐昌廊田PS场", "灌阳新圩PS场", "乐安万崇CS场", "鄱阳田畈街PS场", "恩平沙湖PS场", "马山三乐PS场", "威信扎西PS场", "廊田粤辉PS场", "灵璧虞姬PC场", "东源黄田PC场", "射阳鑫源PS场", "枣阳车站PS场", "宿松华亭PC场", "梓潼定远PC场", "莒县棋山PS场", "昌邑北孟PS场", "赤壁小柏山PS场", "莒县安庄PS场", "樟树观上PS场", "绥阳坪乐PS场", "肥乡旧店PS场", "峨山双江PS场", "分宜凤阳PC场", "仙椿GGP场", "梓潼许州PS场", "抚州东源PS场", "郑墩科城PS场", "益阳军山铺PS场", "阳春潭水PS场", "湘乡月山PS场", "霍邱周集GDU场", "崇左渠西PC场", "耒阳服务部GDU", "平远仲石PS场", "临泉庙岔PS场", "镇雄罗坎GGP场", "霍邱潘集PS场", "万载罗城PS场", "灵山服务部GDU", "衡南宝盖PS场", "安福山庄PS场", "桂阳仁义PS场", "揭阳新亨PS场"};
    private static String[] breeding_addresses = {"中国", "中国江苏省盐城市射阳县临海镇六垛长丰牧业大仓（射阳博鸿CS场）杨效庆", "中国湖北省荆门市沙洋县曾集镇柴集村张烈权", "中国湖南省邵阳市绥宁县红岩镇中国湖南省邵阳市绥宁县红岩镇陡街村久旺猪场前置隔离点收件人牛世伦电话", "中国广西壮族自治区百色市田阳县五村镇天阳村养殖场刘天贵", "中国贵州省铜仁市松桃苗族自治县大兴街道办事处蒲远（电话：）", "中国湖北省荆门市沙洋县曾集镇-湖北省荆门市沙洋县曾集镇雷都村樱花部落沙洋曾集PS场海丁孊-", "中国广西壮族自治区桂林市全州县全州镇邓家埠村朱智清", "中国广西壮族自治区百色市田阳区坡洪镇广西田阳区坡洪镇陀闹屯北200米", "中国浙江省丽水市庆元县竹口镇黄沙坑1号", "", "中国云南省昭通市镇雄县林口彝族苗族乡木黑村双胞胎检测点夏芝勇", "中国安徽省六安市裕安区独山镇六里冲村道班超市东50米六安猪场", "中国江西省抚州市乐安县龚坊镇石里元水库旁双胞胎猪场吴佳静", "中国云南省曲靖市陆良县大莫古镇回辉哨村（陆良双胞胎PS场付雪娇", "中国浙江省衢州市开化县桐村镇裴源村吴家24号，徐安", "中国", "中国", "中国", "中国", "中国江西省新余市分宜县凤阳镇社下村白路塘PS场双胞胎猪场前置点李卫", "中国云南省大理白族自治州祥云县下庄镇大理双胞胎宏茂畜牧有限公司收货人:和建，", "中国福建省南平市松溪县郑墩镇福建省南平市松溪县郑墩镇长盘大路146号永润猪场马一鸣", "中国四川省成都市彭州市桂花镇四川省彭州市桂花镇衡州村9组双胞胎办公室，收件人：高浪：电话：", "中国安徽省安庆市宿松县破凉镇先决小学向东100米双胞胎行政办公点，收货人，明棋，", "中国", "中国江西省新余市分宜县操场乡石塘村分宜双金猪业有限公司易成", "中国广西壮族自治区崇左市江州区左州镇双胞胎二级洗消中心（左州镇那坎村那坎屯崇左公猪站）联系人：何超", "中国", "中国黑龙江省佳木斯市桦川县新城镇黑龙江省佳木斯市桦川县新城镇桦川双兆猪业有限公司高军-", "中国广西壮族自治区崇左市江州区左州镇双胞胎二级洗消中心（渠西CS场二期）收货人：李吉联系方式", "中国广西壮族自治区梧州市藤县金鸡镇双胞胎藤县服务部", "中国江西省赣州市于都县贡江镇长岭村于都双胞胎畜牧有限公司，李润欣", "", "中国江苏省盐城市大丰区万盈镇双胞胎集团小海养猪服务部徐卫宝，", "中国江西省赣州市定南县天九镇长桥村杨坑定南双胞胎畜牧有限公司（需注明：原华鑫猪场）李永石", "中国安徽省宿州市泗县刘圩镇安徽省宿州市泗县刘圩镇四山村北山组389号", "中国江西省宜春市万载县三兴镇江西省宜春市万载县三兴镇杭桥村双胞胎猪场收件人：唐景阳", "中国黑龙江省绥化市望奎县双胞胎饲料厂苏雨超", "中国江苏省宿迁市泗阳县张家圩镇中国江苏省宿迁市泗阳县张家圩镇小史集百果园陈双", "中国四川省宜宾市翠屏区明威镇金秋湖镇明威乡白塔村五组双胞胎集团有限公司", "中国江西省抚州市金溪县左坊镇江西省抚州市金溪县左坊镇米家村金溪双胞胎畜牧有限公司收货人：张乘志电话：", "中国江西省抚州市金溪县左坊镇江西省抚州市金溪县左坊镇米家村金溪双胞胎畜牧有限公司收货人：张乘志电话：", "中国黑龙江省佳木斯市桦川县新城镇桦川梨丰CS场危洪成", "中国安徽省亳州市利辛县汝集镇刘店村双胞胎集团利辛养猪服务部张勇", "中国", "中国", "中国广西壮族自治区来宾市兴宾区六道村", "中国四川省绵阳市游仙区玉河镇盐泉镇共和村6组9号（双胞胎景维猪场董红梅）", "中国江西省九江市武宁县澧溪镇", "中国江西省赣州市赣县区", "中国", "中国", "中国海南省儋州市儋州市光村镇新盈农场", "中国安徽省亳州市蒙城县楚村镇康老庄75号双胞胎前置点", "中国", "中国广东省韶关市始兴县马市镇", "中国", "中国", "中国黑龙江省绥化市望奎县黑龙江省绥化市望奎县厢白满族乡后头村，薛广福", "中国湖南省邵阳市绥宁县红岩镇谢家村架毛坳八组，邹绍平，", "中国浙江省杭州市桐庐县富春江镇象山桥村双胞胎办公室刘永书", "中国", "中国江西省吉安市永新县里田镇里田镇洋湖村（原洋埠采育林场办公楼）靠近洋湖大桥双胞胎猪场前置刘凌峰欧阳官辉", "中国四川省德阳市中江县龙台镇稻花村1组雷海涛", "中国湖南省衡阳市耒阳市坛下乡耒阳双胞胎畜牧有限公司郭帅彬", "中国", "中国安徽省宿州市泗县刘圩镇安徽省宿州市泗县刘圩镇新建村新建小学，刘亮：", "中国河南省许昌市襄城县麦岭镇", "中国安徽省淮南市寿县", "中国安徽省宿州市萧县刘套镇陆庄爱心缘批发超市转双胞胎猪场李长宝", "中国江苏省盐城市东台市东台镇", "中国广西壮族自治区南宁市西乡塘区双定镇", "中国江苏省盐城市响水县小尖镇月港村响水养猪服务部唐伟", "中国湖南省衡阳市耒阳市三都镇", "中国安徽省安庆市宿松县破凉镇先觉村先觉小学往东50米双胞胎办公点，收货人，明棋，电话，", "中国辽宁省沈阳市新民市前当堡镇", "中国", "中国广西壮族自治区双胞胎二级洗消中心崇左渠茗PS场王孙鹫", "中国安徽省蚌埠市怀远县荆山镇牛王村口双胞胎怀远服务部", "中国湖南省郴州市嘉禾县普满乡田美蒋家村-嘉禾普满PS场", "中国山东省临沂市平邑县仲村镇", "中国江苏省淮安市淮阴区棉花庄镇红旗路淮阴服务部", "中国广东省肇庆市怀集县中洲镇双胞胎中洲服务部金堪才电话：", "中国", "中国", "中国", "中国江西省宜春市上高县泗溪镇洋港村双胞胎猪场叶琳", "中国广西壮族自治区河池市巴马瑶族自治县所略乡彩下村双胞胎猪场孙现青", "中国广西壮族自治区梧州市藤县天平镇新兴村双胞胎猪场黄朝超", "中国广西壮族自治区柳州市柳城县大埔镇广西柳州市柳城县大埔镇东建屯95号，柳城双胞胎畜牧有限公司，李辉", "中国辽宁省锦州市北镇市", "中国河南省新乡市封丘县陈固镇", "中国江苏省徐州市新沂市", "中国", "中国", "中国广东省江门市开平市苍城镇联兴村委会罗萌村大造咀1号廖健", "中国湖南省衡阳市常宁市西岭镇黄坪村常宁星顺畜牧有限公司阳伊静", "中国四川省绵阳市游仙区信义镇联合村3组双胞胎联合猪场，彭志强，", "中国四川省绵阳市游仙区魏城镇金华村9社12号，游仙魏城PS场，收货人陈益，电话", "中国广东省韶关市新丰县沙田镇长春村覃小政", "中国", "中国安徽省六安市霍邱县白莲乡牛集村祁永帅", "", "中国", "中国", "中国", "", "", "中国江西省赣州市大余县浮江乡玉里村双胞胎猪场，王钟齐，", "中国贵州省毕节市大方县兴隆苗族乡石板村大方双胞胎畜牧有限公司收货人:张洪国电话号码:", "中国湖北省宜昌市枝江市董市镇双湖一组竹海渔家乐", "中国", "中国湖北省咸宁市赤壁市中伙铺镇泉洪村七组18-1号，艾文达", "中国", "中国江苏省淮安市盱眙县古桑街道白虎村刘老四老鹅馆对面（双胞胎养猪盱眙服务部）路璐", "中国江苏省宿迁市宿城区龙河镇靳桥高速出口向东100米双胞胎集团宿迁养猪服务部朱莹", "中国广西壮族自治区河池市巴马瑶族自治县燕洞镇岩延村吴定恩", "中国", "中国广东省清远市英德市浛洸镇河江渡浛洸加油站谢玉香", "中国广东省清远市英德市桥头镇熊屋组8号（桥头服务部），曾金辉", "中国广东省湛江市廉江市新民镇李荣博", "中国广西壮族自治区贺州市钟山县711县道大耀村双胞胎集团钟山服务部,吴丽芳", "中国江西省赣州市全南县陂头镇正河村松山下大丰猪场（陂头正河PS场），涂鑫池，。", "中国黑龙江省绥化市望奎县南二道街双龙宾馆北侧望奎驿站", "中国江西省新余市渝水区南安乡新村双胞胎龚家猪场章楷明", "中国云南省德宏傣族景颇族自治州盈江县支那乡石分村盈江双胞胎畜牧有限公司", "中国贵州省黔西南布依族苗族自治州安龙县龙广镇贵州省兴义市安龙县龙广镇龙广二中双胞胎前置隔离点（黔西南双胞胎猪业有限公司）汪林军", "中国江西省九江市武宁县澧溪镇罗坪村武宁双胞胎畜牧有限公司，郭彩松", "中国浙江省台州市温岭市滨海镇东片农场二大队，周玉洁", "中国江西省赣州市全南县南迳镇李海", "中国江西省赣州市全南县南迳镇", "中国浙江省丽水市庆元县竹口镇竹上村黄沙坑1号", "中国", "中国", "中国云南省大理白族自治州祥云县下庄镇大理双胞胎宏茂畜牧有限公司祥云下庄CS场GDU收货人：杨兴凤联系电话：", "中国江苏省盐城市射阳县临海镇六垛射阳双胞胎（射阳临海PS场）杨效庆", "中国江西省吉安市遂川县碧洲镇黄岗村遂川双胞胎猪场前置点，黄忠林，", "中国广东省韶关市乳源瑶族自治县一六镇东七村马路顶源冶农牧有限公司，刘迎，", "中国广东省韶关市曲江区枫湾镇大竹山村韶关曲江双胞胎畜牧有限公司（原罗氏猪场），邓晶晶", "中国江西省赣州市全南县南迳镇南迳玉舍猪场（南迳玉舍PS场）李胜亭（转大庄中心仓库）联系方式：", "中国江西省赣州市全南县南迳镇茅山林场---茅山猪场，饶三妹", "中国广东省梅州市梅县区南口镇菏泗太和村黄进塘肖建胜", "中国河南省开封市兰考县仪封园艺场河南省开封市兰考县仪封乡园艺场四队双胞胎猪场----周敏---", "中国江西省赣州市全南县陂头镇周布村曾峰商行转李家洞猪场蓝华电话", "中国四川省绵阳市游仙区观太镇四川省绵阳市游仙区观太镇李华村5社侨致猪场李德果", "中国江苏省盐城市大丰区新丰方强镇长坍村双胞胎大丰养猪服务部", "中国广西壮族自治区梧州市岑溪市双胞胎岑溪服务部", "中国安徽省宿州市泗县草庙镇", "中国", "中国云南省昭通市威信县双河乡半河村", "中国", "中国", "中国江苏省宿迁市泗阳县爱园镇官庄村江苏加华母猪场，马旭康", "中国江西省吉安市吉安县永阳镇下边村荣和猪场，曾绍伟，", "中国安徽省淮南市潘集区贺疃镇安徽省淮南市潘集区贺疃镇塘西村村委会淮南双胞胎猪场孟杰", "中国广东省惠州市惠城区横沥镇增湖村增湖猪场，刘奇山", "中国湖北省孝感市汉川市庙头镇七屋台村，何中玉，联系号码：", "中国广西壮族自治区百色市德保县城关镇那造养殖场（德保CS场），陆啟文：", "中国江西省赣州市全南县南迳镇全南现代牧业甘坑猪场李龙", "中国江苏省盐城市阜宁县罗桥镇射滨村西首1号双胞胎检测点。董杰", "中国河南省周口市扶沟县吕潭乡河南省周口市扶沟县吕潭乡杨村岗村扶沟县双胞胎畜牧有限公司李哲", "中国", "中国安徽省宿州市萧县", "中国", "中国广西壮族自治区钦州市灵山县陆屋镇富久村，罗佳", "中国", "中国云南省大理白族自治州祥云县禾甸镇龙耳厂村冯静", "中国云南省玉溪市峨山彝族自治县甸中镇元山村王卓楠", "中国江苏省盐城市东台市弶港镇新东渔舍村新东幼儿园朱逍，", "中国黑龙江省大庆市大同区林源镇常家围子村老供销社（大庆猪场）李春辉", "中国湖北省十堰市丹江口市蒿坪镇寺沟村左泽晶。", "中国云南省昭通市大关县高桥镇甘顶村烟叶站，大关猪场王义邦", "中国江西省赣州市安远县龙布镇安远双胞胎猪场，收货人:何兆林", "中国广西壮族自治区崇左市江州区左州镇双胞胎二级洗消中心（崇左渠西CS场）收货人：陈姗姗联系方式：", "中国山东省青岛市平度市凤台街道办事处", "中国四川省南充市营山县东升镇锁水村3组", "中国", "中国", "中国", "中国广西壮族自治区百色市靖西市禄峒镇禄峒乡大金村养殖场庞成银", "中国", "中国河南省新乡市延津县司寨乡前新乡屯198号新乡屯茶馆(双胞胎猪场前置点）刘宁", "中国山西省大同市浑源县南榆林乡姜家沟村敬老院（浑源南榆林PS场），姜涛，", "中国河南省河南省直辖县级行政区划济源市济源市大峪镇桥沟村满泉沟双胞胎猪场朱佳林", "中国湖北省襄阳市枣阳市枣阳经济开发区", "中国广东省韶关市乐昌市坪石镇", "中国", "中国", "中国", "中国", "中国", "中国江苏省宿迁市宿城区罗圩乡南罗路江苏中大畜牧有限公司，陈成", "中国江西省抚州市金溪县左坊镇江坊村东排组瓦子岭陈彦兵", "中国湖北省宜昌市当阳市当阳市草埠湖镇胡家山王琪琪", "中国安徽省淮南市田家庵区田东街道", "中国", "中国", "中国", "中国山东省潍坊市青州市谭坊镇孙家村", "中国江西省新余市分宜县高岚乡新棚下云阳猪场，张乘志", "中国安徽省滁州市凤阳县武店镇南断面路双胞胎隔离点，刘梦玉", "中国湖北省襄阳市老河口市", "中国江苏省盐城市滨海县", "中国广西壮族自治区桂林市恭城瑶族自治县恭城镇", "中国", "中国", "中国", "中国广东省韶关市翁源县龙仙镇八字陂（双胞胎全南现代三华服务部），邹一辉", "中国广西壮族自治区崇左市江州区左州镇", "中国江西省宜春市袁州区三阳镇三天段与320国道交界处，双胞胎服务部", "中国", "中国", "中国", "中国", "中国", "中国广西壮族自治区崇左市江州区左州镇", "中国", "中国", "中国", "中国江西省新余市分宜县操场乡上松村肖小龙，电话", "中国黑龙江省绥化市望奎县南五道街与西环交叉口西走50米望奎驿", "中国", "中国", "中国湖南省岳阳市汨罗市范家园镇双胞胎汨罗养猪服务部", "中国安徽省阜阳市阜南县", "中国", "中国", "中国", "中国广东省江门市恩平市大槐镇镇政府（红绿灯处）", "中国河南省郑州市荥阳市王村镇房罗村北800米", "中国广西壮族自治区南宁市隆安县古潭乡", "中国安徽省六安市霍邱县周集镇花园村（双胞胎猪场）收件人：黄勇", "中国", "中国四川省宜宾市翠屏区永兴镇王庙村王家组（双胞胎猪场）李云路", "中国江西省新余市分宜县洋江镇邹吉祥，收货地址江西新余分宜县凤阳镇大路边村分宜金苹果", "中国广东省韶关市乐昌市廊田镇因果猪场前置点（乐源加气站对面）收件人黄检根", "中国广西壮族自治区桂林市灌阳县新圩镇平田村，白盛勇，", "中国江西省抚州市乐安县万崇镇江西省抚州市乐安县万崇镇桐山村塘边双胞胎猪场刘世鹏", "中国江西省上饶市鄱阳县田畈街镇大王山村委会上横坑(摩托车考生中心旁)朱盛权", "中国广东省江门市恩平市沙湖镇咀厚村民委员会火廉山恩平PS场谢苗苗", "中国广西壮族自治区南宁市马山县三乐村村委旁猪场，陆宏源", "中国云南省昭通市威信县扎西镇院子村，曹波，手机:", "中国广东省韶关市乐昌市廊田镇老平农场原原粤辉猪场，收件人李伟强，", "中国安徽省宿州市灵璧县虞姬乡灵光村双胞胎检测点，郑成文，", "中国广东省河源市东源县黄田镇中国广东省河源市东源县黄田镇东源猪场，朱伟勇，联系电话:", "中国江苏省盐城市射阳县临海镇六垛长丰牧业大仓（射阳鑫源PS场）杨效庆", "中国湖北省襄阳市枣阳市琚湾镇范湾村枣阳双胞胎畜牧科技有限公司朱兵", "中国安徽省安庆市宿松县破凉镇先觉村，先觉小学对面林捷", "中国四川省绵阳市梓潼县宝石乡定远乡银河村村委会王仁伟：", "中国", "中国", "中国湖北省咸宁市赤壁市小柏山村赤壁双胞胎畜牧有限公司，胡陈果手机号码:", "中国山东省日照市莒县安庄镇王川社区苇子沟村莒县双胞胎星顺畜牧有限公司安兴PS场王彦飞", "中国江西省宜春市樟树市观上镇横里村横里水库旁（绿环种猪生态科技园）收货人：伯年寿", "中国贵州省遵义市绥阳县坪乐镇解放村绥阳双胞胎猪业有限公司，肖建侠，", "中国河北省邯郸市肥乡区旧店乡北高村（肥乡双胞胎猪场），魏晓峰", "中国云南省玉溪市峨山彝族自治县双江街道总果村双胞胎猪场，陶升雄", "中国江西省新余市分宜县凤阳镇大路边村杨氏宗祠对面分宜双胞胎前置点余扬锋", "中国", "中国四川省绵阳市梓潼县双板镇双板镇净水器旁双胞胎办公点廖容", "中国江西省抚州市临川区高坪镇东源村二组", "中国", "中国湖南省常德市汉寿县军山铺镇湖南省常德市汉寿县军山铺镇锡文庙村益阳军山铺PS场洗消点李莉芳：", "中国广东省阳江市阳春市潭水镇广东省阳江市阳春市潭水镇尧洞堡双胞胎猪场（阳春潭水PS场）郭光超", "中国湖南省湘潭市湘乡市月山镇神山庙村陈家坳组商永平", "中国安徽省六安市霍邱县周集镇宏志中学后双胞胎养猪场", "中国广西壮族自治区崇左市江州区左州镇崇左双胞胎二级洗消中心梁真缘", "中国", "中国广东省梅州市平远县中行镇仲石村平远双胞胎猪场收货人：彭冰冰，电话：", "中国安徽省阜阳市临泉县庙岔镇小李庄村建阳猪场，杨向阳", "中国云南省昭通市镇雄县罗坎镇", "中国安徽省六安市霍邱县潘集镇", "中国江西省宜春市宜丰县芳溪镇江西省宜春市宜丰县芳溪镇木材检查站彭福萍", "中国广西壮族自治区钦州市灵山县", "中国湖南省衡阳市衡南县宝盖镇黄田村31号-衡南PS场", "中国江西省吉安市安福县山庄乡古楼下安福双胞胎畜牧有限公司，朱宇，", "中国湖南省郴州市桂阳县敖泉镇塘汪村联系人：申旺", "中国广东省揭阳市揭东区新亨镇楼下村煜弘种养有限公司（双胞胎揭阳新亨PS场），陈国文，"};

    //    private static int[] svc_ids = {107, 86, 479, 398, 450, 477, 446, 484, 30, 91, 475, 528, 299, 85, 485, 444, 130, 371, 407, 480, 492, 517, 396, 478, 326, 54, 349, 383, 3, 529, 405, 435, 55, 59, 131, 31, 83, 380, 439, 454, 298, 78, 541, 51, 382, 418, 414, 345, 460, 103, 9, 436, 1, 400, 350, 389, 375, 369, 319, 461, 336, 411, 430, 24, 441, 419, 440, 462, 102, 533, 93, 28, 111, 126, 357, 23, 12, 409, 2, 307, 356, 317, 403, 21, 413, 412, 501, 52, 341, 99, 322, 26, 16, 109, 306, 392, 410, 80, 73, 296, 364, 8, 92, 318, 372, 29, 20, 74, 330, 395, 302, 402, 67, 342, 34, 15, 37, 468, 333, 18, 112, 429, 125, 89, 40, 25, 116, 45, 401, 514, 535, 456, 532, 539, 5, 530, 19, 321, 132, 90, 420, 6, 64, 50, 121, 17, 32, 500, 10, 388, 303, 531, 105, 14, 113, 11, 378, 538, 66, 48, 415, 523, 542, 537, 58, 118, 123, 84, 536, 381, 365, 129, 294, 455, 106, 7, 351, 387, 494, 498, 437, 499, 497, 496, 495, 469, 127, 384, 61, 374, 98, 110, 312, 502, 457, 115, 458, 360, 445, 470, 465, 36, 49, 362, 33, 449, 471, 62, 473, 453, 393, 452, 391, 434, 476, 442, 310, 137, 431, 136, 128, 504, 443, 394, 505, 75, 481, 490, 482, 491, 60, 97, 483, 100, 96, 87, 94, 104, 506, 46, 487, 488, 467, 474, 135, 510, 88, 81, 515, 519, 508, 520, 507, 513, 516, 512, 511, 297, 311, 43, 346, 47, 27, 122, 134, 472, 509, 399, 416, 433, 347, 42, 320, 39, 71, 56, 361, 124, 340, 101, 22, 119, 35, 44, 57, 120, 334, 13, 114, 69, 133, 41, 438, 493, 38, 117, 72, 464, 295, 404, 82, 463, 352, 68, 348, 370, 386, 65, 70, 377, 79, 355, 397, 304, 390, 63, 77, 76, 305, 367, 432, 379, 344, 53, 353, 417, 408, 366, 354, 466, 376, 373, 95, 108, 4};
    private static String[] svc_names = {"刘庄服务部", "浠水服务部", "霍邱服务部", "连滩服务部", "藤县服务部", "常宁服务部", "陆屋服务部", "佛冈服务部", "满井服务部", "宜昌众养通服务部", "儋州服务部", "三阳服务部", "贵溪服务部", "宜城服务部", "金堂服务部", "平南服务部", "洪庄服务部", "田东服务部", "随县服务部", "琼海服务部", "醴陵北服务部", "临桂服务部", "钟山金苹果服务部", "龙山服务部", "汨罗服务部", "怀远服务部", "宁都服务部", "大关服务部", "龙坪服务部", "龙岩服务部", "新田服务部", "恭城服务部", "醴陵南服务部", "金山服务部", "吕店服务部", "灵川服务部", "东海服务部", "西乡塘服务部", "兴宾服务部", "东台服务部", "宣威服务部", "巴州服务部", "乳源一六CS场封存", "马湖服务部", "临泉服务部", "版石服务部", "弋阳服务部", "信都服务部", "赣州众养通服务部", "平桂服务部", "凤阳武店CS场封存", "三台服务部", "巴马燕洞CS场封存", "天心服务部", "赣县服务部", "织篢服务部", "圣堂服务部", "大成服务部", "马山服务部", "扶绥服务部", "河源众养通服务部", "海口众养通服务部", "丰城服务部", "桃江服务部", "石林服务部", "信丰服务部", "大丰服务部", "龙台服务部", "廊田服务部", "商水服务部", "安丘服务部", "兴安众养通服务部", "梅州众养通服务部", "新政服务部", "兰山服务部", "英红服务部", "渝水南安CS场封存", "潼南服务部", "莒南相沟CS场封存", "莒南筵宾CS场封存", "蒙城楚村CS场封存", "武鸣服务部", "荥阳王村CS场封存", "坪石服务部", "平度服务部", "游仙信义CS场封存", "阜南服务部", "阳江众养通服务部", "于都服务部", "南迳大庄CS场封存", "封丘陈固CS场封存", "周口众养通服务部", "郑墩双源PS场-育肥线", "威县服务部", "麦岭服务部", "进贤服务部", "剑阁服务部", "马坡服务部(作废)", "崇仁服务部", "霍邱周集CS场封存", "望奎后三CS场封存", "南迳马安CS场封存", "赤壁服务部", "阜宁服务部", "余庆服务部", "祁东服务部", "朝东服务部", "定远服务部", "通城服务部", "小海服务部", "大槐服务部", "马坡服务部", "青疃服务部", "月山服务部", "广水服务部", "凤阳服务部", "宿松香玲CS场封存", "冠县服务部", "琉璃寺服务部", "三华服务部", "莒县棋山CS场封存", "镇远服务部", "巴马服务部", "草庙服务部", "开阳服务部", "山阴薛圐圙CS场封存", "平度崔家集CS场封存", "杜步服务部", "汴塘服务部", "涪陵服务部", "叶县服务部", "坝仔服务部", "龙布服务部", "双定服务部", "莲都服务部", "崇左渠西CS场封存", "洪港服务部", "西充服务部", "武宣服务部", "沧县服务部", "全椒服务部", "潜江服务部", "春湾服务部", "上高服务部", "涡阳服务部", "苍溪服务部", "塔峰服务部", "肥乡服务部", "柳江服务部", "平果服务部", "播州服务部", "赤土服务部", "九集服务部", "老河口服务部", "大余服务部", "衡东服务部", "涪州众养通服务部", "达州众养通服务部", "鄂州众养通服务部", "蓬溪服务部", "平度蓼兰CS场封存", "梓潼定远PC场-育肥线", "瑞金众养通服务部", "信丰众养通服务部", "上高众养通服务部", "抚州众养通服务部", "安顺服务部", "万年众养通服务部", "新建众养通服务部", "钦州众养通服务部", "贺州众养通服务部", "平南众养通服务部", "柳州众养通服务部", "宁乡众养通服务部", "富阳服务部", "沾益服务部", "仁化服务部", "荆州众养通服务部", "盐城众养通服务部", "南宁众养通服务部", "横县众养通服务部", "韶关众养通服务部", "坡造服务部", "新河舒服务部", "三水众养通服务部", "枣阳众养通服务部", "岳阳众养通服务部", "宿豫服务部", "福泉服务部", "三合服务部", "郑墩南坑PS场-育肥线", "嘉禾服务部", "玉林众养通服务部", "灵城服务部", "乐安万崇CS场封存", "泗洪服务部", "和平服务部", "桦川梨丰CS场封存", "弥勒服务部", "利辛服务部", "德保城关CS场-封存", "沙洋沈集PS场-育肥线", "沙洋曾集PS场-育肥线", "荆门团林铺PS场-育肥线", "寿县服务部", "盐亭服务部", "新营山服务部", "洞口服务部", "温岭滨海PS场-育肥线", "兴业服务部", "赤岭服务部", "广安服务部", "融水服务部", "泰和服务部", "柳城服务部", "安岳服务部", "鄱阳服务部", "衡阳服务部", "围底服务部", "万载三兴CS场封存", "孝昌服务部", "都安服务部", "潭水服务部", "枝江服务部", "白沙服务部", "龙源坝服务部", "泗县服务部", "会泽服务部", "东源黄田PC场-育肥线", "汉川服务部", "绥宁服务部", "宿城服务部", "樟树服务部", "零陵服务部", "永兴服务部", "灌阳服务部", "铜梁服务部", "永福服务部", "江油服务部", "蒙城服务部", "新余服务部", "三都服务部", "定安服务部", "滨海服务部", "分宜洋江CS场封存", "中洲服务部", "瑶都服务部", "廉江服务部", "钦南服务部", "晴隆服务部", "新平昌服务部", "泗阳南刘集CS场封存", "咸安服务部", "梓潼服务部", "麻江服务部", "正平服务部", "钟祥服务部", "埇桥服务部", "田阳雷圩CS场封存", "那扶服务部", "金溪左坊CS场封存", "盱眙服务部", "新巴州服务部", "公安服务部", "那大服务部", "仓山服务部", "通山服务部", "六安服务部", "官庄服务部", "蕲春服务部", "金溪石门CS场封存", "彩云服务部", "分宜操场CS场封存", "宜都服务部", "回澜服务部", "泰兴服务部", "祥云刘厂CS场封存", "灵璧服务部", "董塘服务部", "白土服务部", "祥云下庄CS场封存", "武穴服务部", "射洪服务部", "灵璧虞姬PC场-育肥线", "桂阳服务部", "修文服务部", "鹿寨服务部", "河舒服务部", "南亩服务部", "渠县服务部", "金陵服务部", "永新高桥楼PS场-育肥线", "东华服务部", "长宁服务部", "北镇服务部", "禹州苌庄CS场封存", "峨山服务部", "灵山服务部", "夹江服务部", "宁远服务部", "禾云服务部", "邱家服务部", "岑溪服务部", "当阳服务部", "周陂服务部", "先锋服务部", "高坪服务部", "龙游服务部", "前当堡服务部", "石城服务部", "新桥头服务部", "仲村服务部", "马坝服务部", "江尾服务部", "东溪服务部", "临泉庙岔PS场-育肥线", "含山服务部", "望高服务部", "新恭城服务部", "德保城关CS场封存", "祥符万隆CS场封存", "祥符朱仙CS场封存", "威信服务部", "松滋服务部", "宿城罗圩PS场-育肥线", "分水服务部", "监利服务部", "铜山服务部", "永丰服务部", "武胜服务部", "马鞍服务部", "凤台服务部", "新兴服务部", "涟水服务部", "桐梓服务部", "合川服务部", "睢宁服务部", "马市服务部", "元江服务部", "团风服务部", "马龙服务部", "太和服务部", "惠城横沥PS场-育肥线", "观音寺服务部", "沱江服务部", "河田服务部", "江华服务部", "大洋服务部", "钟山服务部", "道县服务部", "塘坝服务部", "望埠服务部", "横县服务部", "大桥服务部", "平原服务部", "肥东服务部", "吉安服务部", "响水服务部", "南漳服务部", "新干服务部", "枣阳服务部", "全州服务部", "赤水服务部", "永新里填PS场-育肥线", "樟树观上PS场-育肥线", "安仁服务部", "耒阳服务部", "禹州苌庄PS场-育肥线", "新塘服务部", "宿松服务部", "富源服务部", "金江服务部", "桦川服务部", "平昌服务部", "安居服务部", "营山服务部", "客路服务部", "沙琅服务部", "恭城服务部(贺州)", "沙塘服务部", "覃塘服务部", "岗美服务部", "岳阳县服务部", "孟良崮服务部", "南雄服务部", "双城服务部", "陆良服务部", "建水服务部", "东联服务部", "澧县服务部", "葵阳服务部", "桥头服务部", "曲江服务部", "陂头正河PS场-育肥线", "开化桐村PS场-育肥线", "耒阳西服务部", "莒南服务部", "纳溪服务部", "官渡服务部", "得禄服务部", "郯城服务部", "兰陵服务部", "恒源服务部", "管镇服务部", "盐山服务部", "淮阴服务部", "新沂服务部", "献县服务部", "庆元竹口CS场封存"};
    private static String[] svc_addresses = {"中国江苏省盐城市大丰区刘庄镇友谊村二组171号双胞胎刘庄养猪服务部，沈桧茹", "中国湖北省黄冈市浠水县清泉镇湖北省黄冈市浠水县清泉镇罗桥村二组六十六号艾小路：", "中国安徽省六安市霍邱县", "中国广东省云浮市郁南县连滩镇逍遥村委逍遥口村连滩服务部李辉强", "中国广西壮族自治区梧州市藤县金鸡镇新地塘村村口376县道傍，蒋潇翰", "中国湖南省衡阳市常宁市新河镇湖南省衡阳市常宁市新河镇五里牌村双胞胎养猪服务部谭霞梅", "中国广西壮族自治区钦州市灵山县陆屋镇富久村黄慧敏", "中国广东省清远市佛冈县高岗镇清远市佛冈县高岗镇X374（瑶塘），收货人：苟进生", "中国四川省眉山市仁寿县满井镇谢江", "中国", "中国海南省儋州市儋州市光村镇新盈农场双胞胎养猪服务部谢河长：", "中国江西省宜春市袁州区三阳镇杆塘村双胞胎集团三阳服务部，彭维", "中国江西省鹰潭市月湖区四青街道办事处江西省鹰潭市月湖区四青街道带宝山括苍山水名城周海浪", "中国湖北省襄阳市宜城市小河镇-明正村四组王赛赛电话", "中国四川省成都市金堂县金堂服务部（简阳市三合镇石岭村三组）", "中国广西壮族自治区贵港市平南县大安镇燕岭村双胞胎集团平南养猪服务部陈保贤", "中国江苏省连云港市东海县洪庄镇洪庄镇教师公寓北门对面双胞胎集团洪庄服务部陈非凡", "中国广西壮族自治区百色市田东县林逢镇平洪村江洪屯83号双胞胎集团田东养猪服务部，李义广，", "中国湖北省随州市随县安居镇王家沙湾村双胞胎集团随县养猪服务部，江旭，", "中国海南省省直辖县级行政区划琼海市嘉积镇俸田乡双胞胎集团琼海养猪服务部，王玉", "中国湖南省株洲市渌口区渌口镇檀园村醴陵北养猪服务部收货人:黄港联系电话:", "中国广西壮族自治区桂林市临桂区临桂镇凤凰村村委上店村村边（双胞胎临桂养猪服务部），韦燕敏", "中国广西壮族自治区贺州市平桂区旺高工业园贺州双胞胎饲料有限公司，廖建兰", "中国福建省漳州市平和县文峰镇安厚农场作业区龟仔头1号陈春秀，", "中国湖南省岳阳市汨罗市，范家园镇240国道旁双胞胎集团汨罗服务部。翁娜收", "中国安徽省蚌埠市怀远县荆芡乡-牛王村双胞胎集团怀远服务部，马凯行，电话", "中国江西省赣州市宁都县竹笮乡宁都外环路法沙村流水组双胞胎宁都服务部肖春香", "中国云南省昭通市大关县玉碗镇-石灰村大关双胞胎服务部。龙生白，电话", "中国广东省清远市连州市连州镇碌角潭双胞胎集团龙坪服务部联系人：邵文卓，", "中国", "中国湖南省永州市新田县三井镇永州市新田县三井镇管家村", "中国广西壮族自治区桂林市恭城县嘉会镇双胞胎恭城养猪服务部收货人:江娟电话号码:", "中国湖南省株洲市醴陵市泗汾镇樟家园组泗汾大桥旁边双胞胎泗汾服务部，谭莎", "中国四川省德阳市罗江区白马关镇白马关凤鸣村2组56号，谢采芹，", "中国", "中国广西壮族自治区桂林市灵川县灵田镇李家桥村双胞胎服务部黄莉珍", "中国江苏省连云港市东海县横沟乡X252双胞胎集团东海养猪服务部程志美", "中国广西壮族自治区南宁市西乡塘区金陵镇三联村双胞胎集团西乡塘服务部（三联村委对面）收货人：韦小玲联系电话：", "中国广西壮族自治区来宾市兴宾区城北街道办事处平西社区古昔村2号", "中国江苏省盐城市东台市许河镇东进村一组双胞胎东台养猪服务部收货人：程志美", "中国云南省曲靖市宣威市凤凰街道河东梨园村82号（双胞胎），林星竹，联系电话：", "中国四川省巴中市巴州区曾口镇宝珠村双胞胎集团巴州养猪服务部，杨春芳，", "中国广东省韶关市乳源瑶族自治县", "中国", "中国安徽省阜阳市临泉县关庙镇安徽省阜阳市临泉县关庙镇王大庄临泉服务部刘宇航（不要发到快递站台）", "中国江西省赣州市安远县版石镇版石镇工业园远通汽修厂内（安远双胞胎养猪服务部）朱东升", "中国江西省上饶市弋阳县南岩镇弋阳看守所协会对面(双胞胎弋阳养猪服务部）王振", "中国广西壮族自治区贺州市八步区信都镇广西贺州市八步区信都镇双胞胎集团（信都）养猪服务部，林碧惠", "中国", "中国广西壮族自治区贺州市平桂区祥和路双胞胎平桂养猪服务部廖建兰", "中国安徽省滁州市凤阳县武店镇武西路南断面，刘芳", "中国四川省绵阳市三台县刘营镇四川省三台县刘营镇安宁梁坪村六组（庙子坡）双胞胎集团三台养猪服务部", "中国广西壮族自治区河池市巴马瑶族自治县燕洞镇子帽村", "中国江西省赣州市安远县天心镇朱德广场旁（双胞胎天心服务部）袁波", "中国江西省赣州市赣县区吉埠镇江西省赣州市赣县区吉埠镇安湖村双胞胎集团赣县养猪服务部刘迎", "中国广东省阳江市阳西县程村镇中西村新村燕妹饭店(发京东或者顺丰)樊艺华", "中国广东省江门市恩平市圣堂镇龙塘村委会白兔村双胞胎公司圣堂服务部（骏捷汽修厂旁），伍丽莉", "中国广东省肇庆市怀集县梁村镇沙田大道斜对面双胞胎集团大成养猪服务部；梁嘉盈手机号码：", "中国广西壮族自治区南宁市马山县周鹿镇丰达农业技术推广站913县道旁（双胞胎集团马山服务部）周大雄", "中国广西壮族自治区崇左市扶绥县中东镇中东加油站往驮卢方向两公里处", "中国", "中国", "中国江西省宜春市丰城市杜市镇水口庙河东派出所旁双胞胎集团丰城服务部凌宗涛", "中国湖南省益阳市桃江县人形山村邹家冲民组，收件人：李进", "中国云南省昆明市石林彝族自治县北大村，王玉玲（）", "中国江西省赣州市信丰县坪石乡-六星村细屋仔10号双胞胎集团信丰养猪服务部温世金", "中国江苏省盐城市大丰区江苏省盐城市大丰区刘庄镇友谊村二组171号刘庄服务部温宏伟，1，沈桧茹", "中国四川省德阳市中江县南华镇南华镇双石村4组（山东格瑞特监理咨询有限公司遂德高速公路SDZJB1标总监办旁），", "中国广东省韶关市乐昌市廊田镇新寮管理区双胞胎乐昌养猪服务部，张婷", "中国河南省周口市西华县清河驿乡河南省周口市西华县清河驿乡清河驿中向西100米双胞胎集团养猪服务部", "中国山东省潍坊市安丘市景芝镇", "中国", "中国", "中国四川省南充市仪陇县柴井乡黄氏祠二组双胞胎服务部李琴;", "中国山东省临沂市兰山区", "中国广东省清远市英德市石灰铺镇走马坪彩虹桥幼儿园斜对面（英红双胞胎养猪服务部），谢玉香", "中国江西省新余市渝水区南安乡显华村棉花田村", "中国重庆市重庆市潼南区龙形镇双胞胎潼南服务部梁语芯", "中国山东省临沂市莒南县相沟镇", "中国山东省临沂市莒南县", "中国安徽省亳州市蒙城县楚村镇朱集村大单庄,马海斌", "中国广西壮族自治区南宁市武鸣区宁武镇（双胞胎集团武鸣服务部）收货人：刘煜阳电话：", "中国河南省郑州市荥阳市王村镇房罗村原三泰猪场朱佳林", "中国湖南省郴州市宜章县栗源镇新坪山粤北加油站斜对面乐昌双胞胎长廊猪业有限公司谢强", "中国山东省青岛市平度市东阁街道办事处双胞胎集团养猪服务部", "中国四川省绵阳市游仙区观太镇四川省绵阳市游仙区观太镇李华村5社侨致农牧，伏鑫，", "中国安徽省阜阳市阜南县焦陂镇阜阳市阜南县焦陂镇阜南养猪服务部李旭，", "中国", "中国江西省赣州市于都县贡江镇长岭村长岭餐馆前100米于都双胞胎畜牧有限公司刘嘉强", "中国江西省赣州市全南县南迳镇大庄村茅山菧中学-全南现代牧业有限公司，物资收货联系人朱乐丰，电话，药品收货联系人钟玉妃电话", "中国河南省新乡市延津县司寨乡前新乡屯198号新乡屯茶馆(双胞胎猪场前置点）王锦飞", "中国", "中国福建省南平市松溪县郑墩镇郑墩村长盘大路146号王光英", "中国河北省邢台市威县枣园乡河北省邢台市威县枣园乡后辛庄村326省道双胞胎威县养猪服务部培朝超市对面刘子勇", "中国广西壮族自治区贺州市富川瑶族自治县麦岭镇（中石化加油站往前300米处）双胞胎集团麦岭服务部毛麒", "中国江西省南昌市进贤县民和镇江西省南昌市进贤县民和镇吴家桥，于阳手机号：", "中国四川省广元市剑阁县白龙镇白龙镇剑锋村四组，崔军", "中国广西壮族自治区玉林市陆川县翔隆精品宾馆收件人：吴旭电话：", "中国江西省抚州市崇仁县迎宾大道492正东方向170米小天地酒楼对面，黄梦翔，", "中国安徽省六安市霍邱县周集镇花园村（双胞胎猪场）收件人：黄勇", "中国黑龙江省绥化市望奎县南六道街小婷超市苏雨超", "中国江西省赣州市全南县南迳镇全南现代牧业有限公司南迳大庄中心仓库钟玉妃转南迳马安CS场钟勇", "中国湖北省咸宁市赤壁市中伙铺镇泉洪村双胞胎赤壁服务部，侯静，电话", "中国江苏省盐城市响水县小尖镇月港村党群服务中心北侧响水服务部刘迎桃", "中国贵州省遵义市余庆县龙溪镇小乌江桥头余庆服务部，杨石坤，", "中国湖南省衡阳市祁东县灵官镇禄桥村3组收货人：彭飞", "中国广西壮族自治区贺州市富川瑶族自治县朝东镇朝东镇朝东加油站后", "中国安徽省滁州市定远县定城镇双庙村(双胞胎集团定远服务部)钟世波", "中国湖北省咸宁市通城县隽水镇桃源村8组什善桥前进200米钟彩霞，", "中国江苏省盐城市大丰区草庙镇沿河村双胞胎集团刘晓雪，电话", "中国广东省江门市恩平市大槐镇江门‭恩平市恩平园区米仓四路59号导航：恩平合璟节能环保科技有限公司。梁燕康", "中国广西壮族自治区玉林市陆川县马坡镇马坡村双胞胎集团马坡养猪服务部联系人：苏俊，", "中国安徽省亳州市涡阳县青疃镇殷庙村(双胞胎集团青疃服务部)耿帅", "", "中国湖北省随州市广水市杨寨镇丁湾村旁双胞胎集团广水服务部朱小玲", "中国安徽省滁州市凤阳县官沟乡瓦屋刘双胞胎服务部，年介婷", "中国安徽省安庆市宿松县破凉镇宿松火车站旁向南50米双胞胎行政办公点，收货人，卞永辉，", "中国山东省聊城市冠县贾镇双胞胎集团冠县服务部，收货人:韩建刚电话:", "中国山东省聊城市茌平县胡屯镇北朱庄村双胞胎集团琉璃寺服务部收货人：公伟", "中国广东省韶关市翁源县龙仙镇八字陂（双胞胎全南现代三华服务部），温爱群", "中国山东省日照市莒县棋山镇", "中国贵州省黔东南苗族侗族自治州镇远县青溪镇贵州省镇远县青溪镇双胞胎镇远服务部（青溪收费站青溪加油站对面）收件人：刘炼余电话：", "中国广西壮族自治区河池市巴马瑶族自治县巴马镇巴马村那桥屯10号双胞胎集团巴马养猪服务部陆金妹", "中国江苏省盐城市大丰区草庙镇沿河村村委会，收货人：刘晓雪电话：", "中国贵州省贵阳市开阳县白安营村谷顶竹组60号，收件人：周猛电话：，", "中国山西省朔州市山阴县薛圐圙乡", "中国山东省青岛市平度市崔家集镇", "中国广东省清远市阳山县七拱镇广东省清远市阳山县七拱镇双胞胎集团杜步服务部邹秀云", "中国江苏省徐州市贾汪区中国江苏省徐州市贾汪区汴塘镇高庄村双胞胎集团汴塘养猪服务部朱雪纯", "中国重庆市重庆市辖区涪陵区新妙镇瓦窑湾大桥（涪陵双胞胎养猪服务部），汪艳军，", "中国河南省平顶山市叶县", "中国广东省韶关市翁源县坝仔镇（双胞胎全南现代坝仔服务部），邓钧林", "中国江西省赣州市安远县龙布镇固营村路口双胞胎集团龙布服务部叶金莲", "中国广西壮族自治区南宁市西乡塘区双定镇周标岭双龙路双定服务部陈诚", "中国广东省肇庆市封开县莲都镇黄塘村双胞胎集团莲都养猪服务部（收货人：黄振伟）", "中国广西壮族自治区崇左市江州区左州镇双胞胎二级洗消中心（崇左渠西CS场）收货人：黄泓凯联系方式：", "中国湖北省咸宁市通山县洪港镇通山县洪港镇茅田河村五组薛雪", "中国四川省南充市南部县建兴镇龙凤乡12组红军垭苏氏家园（双胞胎集团西充服务部）孙丹", "中国广西壮族自治区来宾市武宣县二塘镇广西来宾市、武宣县、二塘镇召村双胞胎集团武宣养猪服务部，方家沛", "中国河北省沧州市沧县", "中国安徽省滁州市全椒县二郎口镇安徽省滁州市全椒县二郎口镇双胞胎全椒养猪服务部曹双双", "中国湖北省省直辖县级行政区潜江市熊口镇丁家沟083乡道双胞胎集体潜江养猪服务部，郑小佩", "中国广东省阳江市阳春市春湾镇双胞胎集团春湾养猪服务部周培东", "中国江西省宜春市上高县敖山镇320国道边敖山敬老院隔壁上高服务部朱锦明", "中国安徽省亳州市涡阳县青疃镇殷庙大袁村委会旁双胞胎集团涡阳养猪服务部王张权：", "中国四川省广元市苍溪县陵江镇红旗桥村2组洺杨山庄，侯艳琼，电话", "中国湖南省永州市蓝山县塔峰镇湖南省永州市蓝山县塔峰镇富阳村塔峰服务部，联系人：谭明朋,电话：", "中国河北省邯郸市肥乡区元固乡沙窝村双胞胎集团肥乡服务部韩维电话", "中国广西壮族自治区柳州市柳江区穿山镇广西柳州市柳江县穿山镇高平村委土桥屯双胞胎集团柳江养猪服务部（原来土桥大排档处）", "中国广西壮族自治区百色市平果县马头镇那厘社区双胞胎集团平果养猪服务部（灵马兄弟饭店总店旁）收货人：黄郑文联系电话：", "中国贵州省遵义市播州区三合镇互合村双胞胎集团播州养猪服务部，王佳贤", "中国福建省漳州市漳浦县赤土乡布垄村第五队林明珍", "中国湖北省襄阳市南漳县九集镇华中绿谷绿谷大道彭家营旁九集服务部石鑫澳", "中国湖北省襄阳市老河口市省道s316杨家山博泰幼儿园收货人：周春丽联系方式：", "中国江西省赣州市南康区浮石乡青云村焦公庙双胞胎集团新城养猪服务部温世金，", "中国湖南省衡阳市衡东县南湾乡双胞胎养猪服务部李燕萍，", "中国", "中国", "中国", "中国四川省遂宁市蓬溪县三凤镇月台村2组51号铁牛山庄，收件人：左雄宇", "中国山东省青岛市平度市蓼兰镇中国山东省青岛市平度市蓼兰镇大吴庄社区西利百农育肥场，张庆，", "中国", "中国", "中国", "中国", "中国", "中国贵州省安顺市西秀区安大厂安宏村大水井组76号，路喜淋手机号", "中国", "中国", "中国", "中国", "中国", "中国", "中国", "中国广西壮族自治区贺州市富川瑶族自治县富阳镇龙母寨村(大围村正对面双胞胎富阳服务部)周丽", "中国云南省曲靖市沾益区花山街道施家屯收费站嘉禾苑宾馆沾益服务部，周颜雄", "中国", "中国", "中国", "中国", "中国", "中国", "中国广西壮族自治区百色市平果县坡造镇武平高速公里对面都阳养护站旁双胞胎集团坡造服务部陈诚", "中国四川省南充市蓬安县河舒镇新桥村双胞胎集团河舒服务部收货人：汤娇电话：", "中国", "中国", "中国", "中国江苏省宿迁市宿豫区侍岭镇吕品", "中国贵州省黔南布依族苗族自治州福泉市牛场镇双龙村赵家院组，龙生白，", "中国", "中国福建省南平市松溪县郑敦镇双源村上坑李欣欣", "中国湖南省郴州市嘉禾县车头镇油涵村38号双胞胎集团嘉禾养猪服务部黄丽群", "中国", "中国安徽省宿州市灵璧县冯庙镇冯庙快递点王传林", "中国江西省抚州市乐安县万崇镇江西省抚州市乐安县万崇镇桐山村塘边双胞胎猪场刘世鹏", "中国江苏省宿迁市泗洪县车门乡王沟村双胞胎泗洪服务部宋猛", "中国广东省河源市和平县公白镇新聚村委会上水角17号b", "中国黑龙江省佳木斯市桦川县新城镇桦川梨丰CS场危洪成", "中国云南省红河哈尼族彝族自治州弥勒市朋普镇一碗水小学（101省道）,收件人：余鑫电话：", "中国安徽省亳州市利辛县汝集镇刘店村双胞胎利辛养猪服务部收货人：王张权，电话：", "中国广西壮族自治区百色市德保县广西百色市德保县那造村那造养殖场收件人：陆啟文电话：", "中国", "中国", "中国", "中国安徽省淮南市寿县茶庵镇关岗村关岗小学对面双胞胎集团寿县养猪服务部收件人：金雪梅电话：", "中国四川省绵阳市盐亭县四川省绵阳市盐亭县高渠镇S101堠溪村3社双胞胎盐亭服务部（四川省园香园味业有限公司旁边）曾峰凡，", "中国四川省南充市营山县东升镇锁水村3组", "中国湖南省邵阳市武冈市湾头桥镇大湾桥村双胞胎洞口服务部宁武：", "中国浙江省台州市温岭市滨海镇东片农场二大队芳草新村(温岭双胞胎畜牧有限公司)丛日飞", "中国广西壮族自治区玉林市兴业县山心镇对塘大村50号，收货人更改为陆思宇，电话", "中国福建省漳州市漳浦县马坪镇漳州市漳浦县马坪镇中国石化天美加油站北50米东", "中国四川省广安市广安区四川省广安市广安区代市镇六桥村", "中国广西壮族自治区柳州市融水苗族自治县融水镇融水双胞胎养猪服务部（一炮过餐饮店对面）收货人：聂毅联系电话：", "中国江西省吉安市泰和县塘洲镇新屋下敬老院对面双胞胎集团泰和服务部丘天晓", "中国广西壮族自治区柳州市柳城县寨隆镇林松加油站旁，罗仕锦", "", "中国", "中国湖南省衡阳市衡阳县演陂镇湖南省衡阳县演陂镇六塘村欧冲组08号，贺聪", "中国广东省云浮市罗定市围底镇-莲塘头村中石化斜对面双胞胎集团罗定养猪服务部冯荣焕，", "中国江西省宜春市万载县三兴镇江西省宜春市万载县三兴镇杭桥村双胞胎猪场收件人：唐景阳", "中国湖北省孝感市孝昌县花园镇-联建村前湾加油站斜对面双胞胎孝昌服务部收货人：张佳佳，", "中国广西壮族自治区河池市都安瑶族自治县安阳镇广西河池市都安瑶族自治县安阳镇双胞胎集团都安养猪服务部韦玲宁", "中国广东省阳江市阳春市潭水镇中国广东省阳江市阳春市潭水镇广东省阳春市潭水镇竹塘村委会横屋村双胞胎养猪服务部周培东，", "中国湖北省宜昌市枝江市", "中国广东省阳江市阳东区合山镇阳江市阳东区合山镇百润石油加油站(利来站)旁边（双胞胎白沙养猪服务部）（只寄顺丰，其他的不送），冯海燕", "中国江西省赣州市全南县龙源坝镇麦坑（双胞胎全南现代金龙服务部）陈日芳", "中国安徽省宿州市泗县大路口乡泗县徽扬集团附近", "中国云南省曲靖市会泽县者海镇阿衣卡村5组(会泽服务部)，联系人：晏祥俊，联系方式：", "中国广东省河源市东源县黄田镇中国广东省河源市东源县黄田镇东源猪场，朱伟勇，联系电话:", "中国湖北省孝感市汉川市城隍镇勤劳村双胞胎养猪服务部王明阳", "中国湖南省邵阳市武冈市湾头桥镇义夫村双胞胎洞口服务部吴建英电话：（必须送货上门，否则拒绝签收）", "中国江苏省宿迁市宿城区龙河镇-双蔡村项庄路口双胞胎集团宿城服务部，朱莹", "中国江西省宜春市樟树市刘公镇八公庄沈刚批发超市旁（双胞胎樟树服务部）胡云", "中国湖南省永州市零陵区黄田铺镇双胞胎集团零陵养猪服务部，饶立文电话:", "中国", "中国广西壮族自治区桂林市灌阳县新圩镇中国广西壮族自治区桂林市灌阳县新圩镇龙塘村", "中国重庆市重庆市铜梁区少云镇重庆市铜梁区少云镇九龙桥（双胞胎集团铜梁养猪服务部）收件人：赵耀。电话：", "中国广西壮族自治区桂林市临桂区四塘镇广西桂林临桂区四塘镇老街（双胞胎集团永福服务部），陈有", "中国四川省绵阳市江油市新安镇梨园路双胞胎集团江油服务部陈太强（）", "中国安徽省亳州市蒙城县三义镇中心幼儿园往东50米，陶华强", "中国江西省新余市渝水区水西镇施家村委曹家村庙前（新余服务部）郭晴", "中国湖南省衡阳市耒阳市三都镇双胞胎集团三都养猪服务部。姜霞，", "中国海南省省直辖县级行政区划定安县定城镇唐林军", "中国江苏省盐城市滨海县陈涛镇丁墩小学，收货人：顾静", "中国江西省新余市分宜县洋江镇邹吉祥，收货地址江西新余分宜县凤阳镇大路边村分宜金苹果", "中国广东省肇庆市怀集县中洲镇中心村富岗村路口双胞胎集团中洲养猪服务部，收货人：陈火炘，电话：", "中国湖南省永州市江永县上江圩镇上江圩村三组105号", "中国广东省湛江市廉江市青平镇中垌村百货一站廉江服务部收货人：吴土春", "中国广西壮族自治区钦州市钦南区康熙岭镇广西钦州市钦南区康熙岭镇西围村委会石头坑队43一1号。姓名：张美娟电话：", "中国贵州省黔西南布依族苗族自治州晴隆县莲城镇蔡家社区二股田双胞胎，刘彪，", "中国四川省巴中市平昌县同州街道办事处同州街道长印社区（原坦溪镇）苟家沟桥头,杨欣，", "中国江苏省宿迁市泗阳县张家圩镇中国江苏省宿迁市泗阳县张家圩镇小史集百果园吕品", "中国湖北省咸宁市咸安区横沟桥镇杨畈村20组1号（双胞胎集团咸安服务部）雷珊", "中国四川省绵阳市游仙区魏城镇-莲花村一社83号，李文", "中国贵州省黔东南苗族侗族自治州麻江县龙山镇孟江村双胞胎麻江养猪服务部姓名:龙生白电话:", "中国江西省赣州市信丰县小河镇连塘下双胞胎正平服务部收件人：肖相斌联系电话：", "中国湖北省荆门市钟祥市双河镇丽山村双胞胎钟祥养猪服务部收件人：肖霞联系电话：", "中国安徽省宿州市埇桥区曹村镇中国安徽省宿州市埇桥区曹村镇双胞胎集团埇桥服务部黄冰杰，", "中国", "中国广东省江门市台山市深井镇台山市深井镇那扶圩富民路三号（那扶双胞胎）李锡明（不要使用德邦物流配送，该物流不能直达服务部）", "中国江西省抚州市金溪县左坊镇江西省抚州市金溪县左坊镇米家村金溪双胞胎畜牧有限公司收货人：张乘志电话：", "中国江苏省淮安市盱眙县玉兰大道68号双胞胎养猪盱眙服务部路璐（快递使用顺丰或者京东）", "中国四川省巴中市巴州区曾口镇宝珠村双胞胎集团巴州养猪服务部", "中国湖北省荆州市公安县斗湖堤镇东风村11组公安养猪服务部。王静", "中国海南省儋州市市辖区海南省儋州市大成镇对娥（商业大道路旁）", "中国四川省德阳市中江县仓山镇南华村十五组双胞胎集团仓山服务部，杨梅，", "中国湖北省咸宁市通山县通羊镇湖北省咸宁市通山县通羊镇岭下村双胞胎集团养猪服务部徐聪", "中国安徽省六安市金安区施桥镇双胞胎服务部，，郭雷蒙，", "中国湖北省襄阳市宜城市板桥镇湖北省宜城市板桥店镇牌坊村候新江", "中国湖北省黄冈市蕲春县湖北省黄冈市蕲春县漕河镇马冲村高速入口双胞胎养猪服务部：甘文霞，电话：/", "中国江西省抚州市金溪县左坊镇江西省抚州市金溪县左坊镇米家村金溪双胞胎畜牧有限公司收货人：张乘志电话：", "中国云南省曲靖市师宗县漾月街道新村路口双胞胎服务部，卢科丞：", "中国江西省新余市分宜县操场乡-石塘村分宜双金猪业有限公司潘际琳", "中国湖北省宜昌市宜都市", "中国四川省资阳市乐至县回澜镇刘攀，", "中国江苏省泰州市泰兴市古溪镇横垛镇创业路润娜时装有限公司王单", "中国云南省大理白族自治州祥云县刘厂镇大波那村公所沙地村收货人:郑云涛电话号码：", "中国", "中国广东省韶关市仁化县G535国道高宅村路口（双胞胎集团董塘养猪服务部），蒙书俊，", "中国广东省韶关市曲江区白土镇新建下乡大道旁，朱彦苹", "中国云南省大理白族自治州祥云县下庄镇大理双胞胎宏茂畜牧有限公司崔丽", "中国湖北省黄冈市武穴市大金镇双胞胎集团武穴服务部收货人：刘草联系方式：", "中国四川省遂宁市射洪县太和镇四川省遂宁市射洪市太和镇余家林村双胞胎养猪射洪服务部，杨梅", "中国安徽省宿州市灵璧县虞姬乡灵光小学正对面双胞胎公司徐同安", "中国湖南省郴州市桂阳县潭西路溪里魏家双胞胎集团桂阳服务部（桂阳一中往浩塘方向）收货人：李德福电话：", "中国", "中国广西壮族自治区柳州市鹿寨县鹿寨镇", "中国四川省南充市蓬安县河舒镇新桥村双胞胎集团河舒服务部收货人：袁菁，", "中国广东省韶关市南雄市南亩镇樟屋村委会沉屋村小组25联系人：刘凯阳", "中国四川省达州市渠县黄花大道南段鞍山村2社85号（收货人：周婷，）", "中国广西壮族自治区南宁市西乡塘区金陵镇陆平村那平坡五组（双胞胎集团金陵养猪服务部）。韦小玲", "中国江西省吉安市永新县高桥楼镇官山农场嘉华生态", "中国广东省清远市英德市桥头镇五石村熊屋组7号桥头双胞胎服务部。廖新望，", "中国四川省宜宾市长宁县长宁镇天星村六组胡珊", "中国辽宁省锦州市北镇市廖屯镇双河堡村常兴路口北镇服务部，宋晓旭", "中国", "中国云南省玉溪市峨山县甸中镇甸尾村夕阳村岔路口；卢科丞，。", "中国广西壮族自治区钦州市灵山县武利镇老包冲对面灵合二级路旁（双胞胎集团灵山养猪服务部），张春兰", "中国四川省乐山市乐山市市中区台子村2组37号收货人:彭艺，", "中国", "中国广东省清远市清新区禾云镇云街村委会军田村双胞胎集团禾云服务部，许洁银，", "中国四川省巴中市平昌县邱家镇万兴村双胞胎集团邱家服务部，谢云雄，", "中国广西壮族自治区梧州市岑溪市石龙冲双胞胎岑溪服务部（牛岭界饭店前400米)", "中国湖北省宜昌市当阳市当阳市王店镇王店镇木店村8组", "中国广东省韶关市翁源县周陂镇陈村加油站附近双胞胎现代服务部收件人:伍凡英电话", "中国黑龙江省绥化市望奎县南五道街与西环交叉口西走50米望奎驿，危宏成", "中国四川省南充市高坪区青居镇华严村1组双胞胎集团高坪服务部，王羿杰，", "中国浙江省衢州市龙游县塔石镇泽随村双胞胎龙游养猪服务部联系人：黄思楠", "中国辽宁省沈阳市新民市前当堡镇自来水厂西院，刘猛，", "中国", "中国广东省清远市英德市桥头镇熊屋组七号桥头双胞胎服务部，林玉路，电话", "中国", "中国广东省韶关市曲江区马坝镇转溪桥头对面双胞胎集团马坝服务部叶细萍收", "中国广东省韶关市翁源县江尾镇244省道旁双胞胎全南现代牧业江尾服务部王丽芸", "中国四川省广元市苍溪县东溪镇双胞胎集团东溪服务部，宋秉儒，。", "中国安徽省阜阳市临泉县庙岔镇小李庄村徐庄向北200米崔胆科", "中国安徽省马鞍山市含山县昭关镇大贺村双胞胎含山养猪服务部。许京，", "中国广西壮族自治区贺州市钟山县双胞胎集团望高养猪服务部（清池路口大坝头小杨商店旁）收货人:廖健兰，联系电话", "中国广西壮族自治区桂林市恭城县嘉会镇双胞胎恭城养猪服务部收货人：江娟电话号码：", "中国广西壮族自治区百色市德保县城关镇那造村那造养殖场（德保CS场），许冯亮", "中国河南省开封市祥符区万隆乡雷岗村天天猪场，李道旺", "中国河南省开封市祥符区朱仙镇", "中国云南省昭通市威信县双河乡半河村威信服务部，收货人:吴晓钦，电话:", "中国湖北省荆州市松滋市街河市镇", "中国江苏省宿迁市宿城区罗圩乡罗圩街道西张威", "中国湖北省孝感市汉川市分水镇界牌处分水养猪服务部吴影", "中国湖北省荆州市监利县红城乡姜老湾村委会路口，王燕", "中国江苏省徐州市铜山区房村镇下洪村S324路南刘雪晴", "中国江西省吉安市永丰县沿陂镇枕头村四都岭，何文龙，", "中国四川省广安市武胜县沿口白滩村一组双胞胎养猪服务部收货人：向雪梅", "中国四川省南充市仪陇县三河镇河街村四方田，收件人：沈津民联系电话：", "中国安徽省淮南市凤台县桂集镇西龚村前龚队创赢公司东边凤台服务部章勇", "中国广东省肇庆市高要区活道镇高要区活道镇S273（益发养殖有限公司）对面", "中国江苏省淮安市涟水县", "中国四川省宜宾市江安县桐梓镇", "中国重庆市重庆市辖区合川区", "中国江苏省徐州市睢宁县王集镇邮局西700米双胞胎集团，王新蕊", "中国广东省韶关市始兴县马市镇都堂村寡婆桥双胞胎集团始兴养猪服务部（马市服务部）联系人：张莹", "中国云南省玉溪市元江哈尼族彝族傣族自治县李想", "中国湖北省黄冈市浠水县清泉镇罗桥村二组六十六号黄邹军", "中国云南省曲靖市马龙区", "中国安徽省阜阳市太和县双浮镇进村村委会旁边双胞胎太和服务部李旭", "中国广东省惠州市惠城区横沥镇增湖村温明波", "中国江苏省淮安市盱眙县马坝镇蔡庄村破山沟观音寺服务部（原破山沟农家乐）", "中国湖南省永州市江华瑶族自治县桥头铺镇下下蒋新村蒋琴，", "中国福建省龙岩市长汀县河田镇朱溪村新下路13号", "中国湖南省永州市江华瑶族自治县白芒营镇207国道高车街乾方旅行社右边，黎云妹", "中国广西壮族自治区贵港市桂平市社步镇往明科方向地磅旁双胞胎猪业有限公司，丘雪燕", "中国广西壮族自治区贺州市钟山县711县道大耀村双胞胎集团钟山服务部,吴丽芳", "中国湖南省永州市道县上关街道道县双胞胎上关养猪服务部，收货人：游鹏程联系电话：", "中国重庆市重庆市辖区潼南区塘坝镇双胞胎集团塘坝服务部，张衡清。", "中国广东省清远市英德市望埠镇双胞胎集团养猪服务部（三包加油站旁），收货人：谭运珍", "中国广西壮族自治区南宁市横县石塘镇村委黄屋村061号，郑丽云联系电话：", "中国江西省赣州市信丰县新田镇半径香炉寨下双胞胎大桥服务部，麦坚", "中国山东省德州市夏津县苏留庄镇", "中国安徽省合肥市肥东县八斗镇八斗社区人民政府旁300米刘伟", "中国江西省吉安市吉安县横江镇良枧村良枧小学吉安双胞胎畜牧有限公司，肖君", "中国江苏省盐城市响水县小尖镇张集乡月港村双胞胎响水服务部（收）刘迎桃，联系方式", "中国湖北省襄阳市南漳县城关镇大堰冲村一组2号，罗理会", "中国江西省吉安市新干县沂江乡牛增村，周敏", "中国湖北省襄阳市枣阳市环城王寨316国道与齐集村交界处大红门农庄，王莉", "中国广西壮族自治区桂林市全州县石塘镇大岗面村157号双胞胎集团全州服务部", "中国广东省江门市开平市赤水镇大津过水塘村路口永丰学校旁（双胞胎集团赤水养猪服务部），只发顺丰（只有顺丰送货），梁金益", "中国江西省吉安市永新县里田镇弓田村苏里岭村中石化加油站（双胞胎猪场）", "中国江西省宜春市樟树市观上镇横里水库樟树双胞胎猪场", "中国湖南省郴州市安仁县灵官镇工业园212省道旁双胞胎安仁养猪服务部，周爱梅", "中国湖南省衡阳市耒阳市龙塘镇红桥六组双胞胎集团耒阳服务部，余楠昭：", "中国河南省许昌市禹州市", "中国广东省惠州市惠阳区新圩镇翩翩酒店，廖正磊，", "中国安徽省安庆市宿松县长铺镇派出所斜对面双胞胎集团宿松服务部李林林", "中国云南省曲靖市富源县富村镇沙树林，高付平，", "中国海南省省直辖县级行政区划澄迈县加乐镇乐新路仙源园，谢春森", "中国黑龙江省佳木斯市桦川县桦川一中音乐楼对面乐加乐食品公司旁（桦川服务部），收货人：袁振鹏电话：", "中国四川省巴中市平昌县坦溪镇立垭村，杨欣，", "中国四川省遂宁市安居区白马镇治平寺村12社23号双胞胎养猪服务部收件人：左雄宇", "中国四川省南充市营山县东升镇锁水村3组", "中国广东省湛江市雷州市客路镇高上村双胞胎集团客路服务部郭家林", "中国广东省茂名市电白县沙朗镇双胞胎集团沙琅服务部，杨惠", "中国", "中国广东省清远市英德市石牯塘镇横坡村委会横坡文化室对面双胞胎集团沙塘养猪服务部，侯永群，", "中国广西壮族自治区贵港市覃塘区石卡镇陆村双胞胎集团贵港养猪服务部（黄沙鳖生态养殖基地对面），文祖满，", "中国广东省阳江市阳春市岗美镇春江一路鸿泰公寓刘儋", "中国湖南省岳阳市岳阳县杨林街镇四龙村许家组24号胡艳菲", "中国山东省临沂市沂南县苏村镇", "中国广东省韶关市南雄市湖口镇长市山庄双胞胎南雄服务部收货人：黄天娣电话：", "中国黑龙江省哈尔滨市双城区同心满族乡同德村", "中国云南省曲靖市陆良县中枢街道办事处云南省曲靖市陆良县中枢镇南昌村双胞胎养猪服务部，夏晨曦", "中国云南省红河哈尼族彝族自治州建水县临安镇东村409号建水服务部，收件人:李鸿坪，电话号码：", "中国广东省梅州市丰顺县汤坑镇交警大队旁金贵大道双胞胎东联服务部收件人：黄瑞旭电话：", "中国湖南省常德市澧县梦溪镇双胞胎养猪服务部联系人谭霞梅", "中国广西壮族自治区玉林市兴业县葵阳镇泉江村（原铁联水泥厂）；收货人：蒙小港；电话：", "中国广东省清远市英德市桥头镇五石村委熊屋组7号，双胞胎全南现代桥头服务部", "中国广东省韶关市曲江区马坝镇转溪村新下丘（双胞胎曲江服务部），何生长", "中国江西省赣州市全南县陂头镇正河村黎晓庆", "中国浙江省衢州市开化县桐村镇裴源村吴家自然村徐志明", "中国湖南省衡阳市耒阳市余庆街道办事处余冲村二组。贺湘林电话：", "中国山东省临沂市莒南县筵宾镇", "中国四川省泸州市纳溪区渠坝镇政府街故里情源工程项目部对面（双胞胎集团纳溪养猪服务部），尹先梅，", "中国广东省韶关市翁源县官渡镇金桂路双胞胎官渡服务部，梁妙美", "中国云南省曲靖市宣威市复兴街道复兴社区居委会青刺沟村39号双胞胎猪业有限公司，黄赢，联系电话", "中国山东省临沂市郯城县庙山镇", "中国山东省临沂市罗庄区褚墩镇青石塘村双胞胎兰陵服务部于谦", "中国山东省德州市临邑县恒源办事处大卢村（340国道东原明星饭店）双胞胎服务部菅恒伟，手机号", "中国江苏省淮安市盱眙县管镇镇宗岗村公路组双胞胎集团管镇养猪服务部，贺大伟，", "中国河北省沧州市盐山县边务乡城南开发区常金路口双胞胎集团盐山县服务部，袁瑞娟", "中国江苏省淮安市淮阴区棉花镇红旗路与福源路交汇处双胞胎集团淮阴养猪服务部", "中国江苏省徐州市新沂市唐店街道东岭村六组江海食品厂路东（双胞胎集团新沂养猪服务部）收货人：陈艳", "中国河北省沧州市献县", "中国浙江省丽水市庆元县竹口镇工业圆区路口，张林梅"};

    private static void geoCoding() {
        String geoCodingApi = "https://api.map.baidu.com/geocoding/v3/?address=%s&output=json&ak=%s";
        Gson gson = new Gson();
        GeoCodingResult geoCodingResult;
//        if (slaughter_names.length != slaughter_addresses.length) {
//            System.out.println("slaughter_names.length: " + slaughter_names.length);
//            System.out.println("slaughter_addresses.length: " + slaughter_addresses.length);
//            System.out.println("请检查输入数据");
//            System.exit(1);
//        }
//        System.out.println(slaughter_names.length);
//        ArrayList<Slaughter> slaughterArrayList = new ArrayList<>();
//        for (int i = 0; i < slaughter_names.length; i++) {
//            Slaughter slaughter = new Slaughter();
//            slaughter.setName(slaughter_names[i]);
//            slaughter.setHome_address(slaughter_addresses[i]);
//            String resultString = doGet(String.format(geoCodingApi, slaughter_addresses[i].replaceAll("\\s+", ""), aks[0]));
//            geoCodingResult = gson.fromJson(resultString, GeoCodingResult.class);
//            slaughter.setLatitude(geoCodingResult.getResult().getLocation().getLat());
//            slaughter.setLongitude(geoCodingResult.getResult().getLocation().getLng());
//            slaughterArrayList.add(slaughter);
//        }
//        System.out.println(updateSql(slaughterArrayList));
//        writeObjectToFile(slaughterArrayList, "src/distance/dat/slaughter_object2.dat");
//        writeFile(updateSql(slaughterArrayList), "src/distance/sql/slaughter_sql2.sql");
//        exportExcel(slaughterArrayList, "src/distance/excel/屠宰场2.xlsx");

//        if (breeding_names.length != breeding_addresses.length) {
//            System.out.println("slaughter_names.length: " + breeding_names.length);
//            System.out.println("slaughter_addresses.length: " + breeding_addresses.length);
//            System.out.println("请检查输入数据");
//            System.exit(1);
//        }
//        System.out.println(breeding_names.length);
//        ArrayList<Breeding> breedingArrayList = new ArrayList<>();
//        for (int i = 0; i < breeding_names.length; i++) {
//            Breeding breeding = new Breeding();
//            breeding.setName(breeding_names[i]);
//            breeding.setHome_address(breeding_addresses[i]);
//            if (breeding.getHome_address().length() > 10) {
//                String resultString = doGet(String.format(geoCodingApi, breeding_addresses[i].replaceAll("\\s+", ""), aks[1]));
//                geoCodingResult = gson.fromJson(resultString, GeoCodingResult.class);
//                if (geoCodingResult.getStatus() != 0) {
//                    System.out.println(breeding.getName() + ": " + geoCodingResult);
//                    continue;
//                }
//                breeding.setLatitude(geoCodingResult.getResult().getLocation().getLat());
//                breeding.setLongitude(geoCodingResult.getResult().getLocation().getLng());
//            }
//            breedingArrayList.add(breeding);
//        }
//        System.out.println(updateSql(breedingArrayList));
//        writeObjectToFile(breedingArrayList, "src/distance/dat/breeding_object0.dat");
//        writeFile(updateSql(breedingArrayList), "src/distance/sql/breeding_sql0.sql");
//        exportExcel(breedingArrayList, "src/distance/excel/种猪场0.xlsx");

        if (svc_names.length != svc_addresses.length) {
            System.out.println("svc_names.length: " + svc_names.length);
            System.out.println("svc_addresses.length: " + svc_addresses.length);
            System.out.println("请检查输入数据");
            System.exit(1);
        }
        System.out.println(svc_names.length);
        ArrayList<Svc> svcArrayList = new ArrayList<>();
        for (int i = 0; i < svc_names.length; i++) {
            Svc svc = new Svc();
            svc.setName(svc_names[i]);
            svc.setHome_address(svc_addresses[i]);
            if (svc.getHome_address().length() > 10) {
                String resultString = doGet(String.format(geoCodingApi, svc_addresses[i].replaceAll("\\s+", ""), aks[1]));
                geoCodingResult = gson.fromJson(resultString, GeoCodingResult.class);
                if (geoCodingResult.getStatus() != 0) {
                    System.out.println(svc.getName() + ": " + geoCodingResult);
                    continue;
                }
                svc.setLatitude(geoCodingResult.getResult().getLocation().getLat());
                svc.setLongitude(geoCodingResult.getResult().getLocation().getLng());
            }
            svcArrayList.add(svc);
        }
        System.out.println(updateSql(svcArrayList));
        writeObjectToFile(svcArrayList, "src/distance/dat/svc_object00.dat");
        writeFile(updateSql(svcArrayList), "src/distance/sql/svc_sql00.sql");
        exportExcel(svcArrayList, "src/distance/excel/服务部00.xlsx");

//        if ((svc_ids.length != svc_names.length) || (svc_ids.length != svc_addresses.length)) {
//            System.out.println("svc_ids.length: " + svc_ids.length);
//            System.out.println("svc_names.length: " + svc_names.length);
//            System.out.println("svc_addresses.length: " + svc_addresses.length);
//            System.out.println("请检查输入数据");
//            System.exit(1);
//        }
//        System.out.println(svc_names.length);
//        ArrayList<Svc> svcArrayList = new ArrayList<>();
//        for (int i = 0; i < svc_names.length; i++) {
//            Svc svc = new Svc();
//            svc.setId(svc_ids[i]);
//            svc.setName(svc_names[i]);
//            svc.setHome_address(svc_addresses[i]);
//            String resultString = doGet(String.format(geoCodingApi, svc_addresses[i].replaceAll("\\s+", ""), aks[0]));
//            geoCodingResult = gson.fromJson(resultString, GeoCodingResult.class);
//            svc.setLatitude(geoCodingResult.getResult().getLocation().getLat());
//            svc.setLongitude(geoCodingResult.getResult().getLocation().getLng());
//            svcArrayList.add(svc);
//        }
//        System.out.println(updateSql(svcArrayList));
//        writeObjectToFile(svcArrayList, "src/distance/dat/svc_object.dat");
//        writeFile(updateSql(svcArrayList), "src/distance/sql/svc_sql.sql");
//        exportExcel(svcArrayList, "src/distance/excel/服务部.xlsx");
    }

    private static void routeMatrix() {
        // 根据经纬度计算路程 API
        String routeMatrixApi = "https://api.map.baidu.com/routematrix/v2/driving?output=json&origins=%s&destinations=%s&ak=%s";
        ArrayList<Distance> distanceArrayList = new ArrayList<>();
        // 读取服务部和屠宰场信息
        ArrayList<Svc> svcArrayList = castArrayList(readObjectFromFile("src/distance/dat/svc_object.dat"), Svc.class);
        ArrayList<Slaughter> slaughterArrayList = castArrayList(readObjectFromFile("src/distance/dat/slaughter_object.dat"), Slaughter.class);
        int i = 0, j = 0, k = 0;
        // 读取进度
        File file = new File("src/distance/dat/distance_object_temp.dat");
        if (file.exists()) {
            distanceArrayList = castArrayList(readObjectFromFile("src/distance/dat/distance_object_temp.dat"), Distance.class);
            i = distanceArrayList.size() / slaughterArrayList.size();
            j = distanceArrayList.size() % slaughterArrayList.size();
        }
        // 写入数据库时的主键
        int nextId = distanceArrayList.size() + 1;
        Gson gson = new Gson();
        RouteMatrixResult routeMatrixResult;
        for (; i < svcArrayList.size(); i++) {
            for (; j < slaughterArrayList.size(); j++) {
                System.out.println(i + "," + j);
                Svc svc = svcArrayList.get(i);
                Slaughter slaughter = slaughterArrayList.get(j);
                // 调用接口
                String resultString = doGet(String.format(routeMatrixApi, svc.getLocation(), slaughter.getLocation(), aks[k]));
                // 返回的结果转换成对象
                routeMatrixResult = gson.fromJson(resultString, RouteMatrixResult.class);
                // 失败
                if (routeMatrixResult.getStatus() != 0) {
                    System.out.println(aks[k] + ": " + routeMatrixResult.getMessage());
                    // 所有 ak 的额度全部使用完了，保存进度后退出
                    if (++k == aks.length) {
                        writeObjectToFile(distanceArrayList, "src/distance/dat/distance_object_temp.dat");
                        writeFile(gson.toJson(distanceArrayList), "src/distance/json/distance_temp.json");
                        System.exit(1);
                    } else {
                        // 还有 ak 没有使用，换下一个 ak 继续
                        j--;
                        continue;
                    }
                }
                Distance distance = new Distance(nextId++, svc.getId(), svc.getName(), slaughter.getId(), slaughter.getName(),
                        routeMatrixResult.getResult().get(0).getDistance().getValue(), routeMatrixResult.getResult().get(0).getDistance().getText());
                distanceArrayList.add(distance);
            }
            // 暂时保存进度，防止意外中止程序丢失所有新查询到的数据
            writeObjectToFile(distanceArrayList, "src/distance/dat/distance_object_temp.dat");
            writeFile(gson.toJson(distanceArrayList), "src/distance/json/distance_temp.json");
            j = 0;
        }
        // 全部完成，保存结果
        writeObjectToFile(distanceArrayList, "src/distance/dat/distance_object.dat");
        writeFile(gson.toJson(distanceArrayList), "src/distance/json/distance.json");
        writeFile(insertSql(distanceArrayList), "src/distance/sql/distance_sql.sql");
        exportExcel(distanceArrayList, "src/distance/excel/距离.xlsx");
        // 写入数据库
        insertDistanceToDatabase(distanceArrayList);
    }

    private static void insertDistanceToDatabase(ArrayList<Distance> distanceArrayList) {
        String resource = "distance/mybatis-config.xml";
        try {
            InputStream inputStream = Resources.getResourceAsStream(resource);
            SqlSessionFactory sqlSessionFactory = new SqlSessionFactoryBuilder().build(inputStream);
            SqlSession sqlSession = sqlSessionFactory.openSession();
            DistanceMapper distanceMapper = sqlSession.getMapper(DistanceMapper.class);
            int subNumber = 3000;
            int start = 0, end;
            // 获取数据库中已有的最大 id
            Integer maxId = distanceMapper.selectMaxId();
            if (maxId != null) {
                start = maxId;
            }
            // 一次插入太多会报错，分多次执行
            for (; start < distanceArrayList.size(); start = end) {
                if ((end = start + subNumber) > distanceArrayList.size()) {
                    distanceMapper.saveDistances(distanceArrayList.subList(start, distanceArrayList.size()));
                } else {
                    distanceMapper.saveDistances(distanceArrayList.subList(start, end));
                }
                sqlSession.commit();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static double getDistance() {
        double lat1 = Math.toRadians(26.3630807394123);
        double lat2 = Math.toRadians(44.404162295632399);
        double lng1 = Math.toRadians(104.23552668649454);
        double lng2 = Math.toRadians(129.4906018925897);
        double s = Math.acos(Math.cos(lat1) * Math.cos(lat2) * Math.cos(lng1 - lng2) + Math.sin(lat1) * Math.sin(lat2));
        return s * 6371;
    }

    public static void main(String[] args) {
//        System.out.println(getDistance());
        routeMatrix();
        geoCoding();
    }

//    public static void main(String[] args) {
//        String resource = "distance/mybatis-config.xml";
//        try {
//            InputStream inputStream = Resources.getResourceAsStream(resource);
//            SqlSessionFactory sqlSessionFactory = new SqlSessionFactoryBuilder().build(inputStream);
//            SqlSession sqlSession = sqlSessionFactory.openSession();
//
//            Gson gson = new Gson();
//            GeoCodingResult codingResult;
//
//            ResGroupsMapper svcMapper = sqlSession.getMapper(ResGroupsMapper.class);
//            Svc svc1 = svcMapper.selectSvc(4);
//            Svc svc2 = svcMapper.selectSvc(516);
//            ArrayList<Svc> svcArrayList = new ArrayList<>();
////            ArrayList<Svc> svcArrayList = svcMapper.selectSvcs();
//            svcArrayList.add(svc1);
//            svcArrayList.add(svc2);
//            for (Svc svc : svcArrayList) {
//                codingResult = gson.fromJson(HttpUtil.doGet(String.format(geoCodingApi, svc.getHome_address().replaceAll("\\s+", ""))), GeoCodingResult.class);
//                if (null != codingResult && null != codingResult.getResult()) {
//                    svc.setLongitude(codingResult.getResult().getLocation().getLng());
//                    svc.setLatitude(codingResult.getResult().getLocation().getLat());
//                }
//            }
////            svcMapper.updateSvcs(svcArrayList);
////            sqlSession.commit();
//
//            SlaughterMapper slaughterMapper = sqlSession.getMapper(SlaughterMapper.class);
//            Slaughter slaughter1 = slaughterMapper.selectSlaughter(41462);
//            Slaughter slaughter2 = slaughterMapper.selectSlaughter(41463);
//            ArrayList<Slaughter> slaughterArrayList = new ArrayList<>();
////            ArrayList<Slaughter> slaughterArrayList = slaughterMapper.selectSlaughters();
//            slaughterArrayList.add(slaughter1);
//            slaughterArrayList.add(slaughter2);
//            for (Slaughter slaughter : slaughterArrayList) {
//                codingResult = gson.fromJson(HttpUtil.doGet(String.format(geoCodingApi, slaughter.getHome_address().replaceAll("\\s+", ""))), GeoCodingResult.class);
//                if (null != codingResult && null != codingResult.getResult()) {
//                    slaughter.setLongitude(codingResult.getResult().getLocation().getLng());
//                    slaughter.setLatitude(codingResult.getResult().getLocation().getLat());
//                }
//            }
////            slaughterMapper.updateSlaughters(slaughterArrayList);
////            sqlSession.commit();
//
//            int i = 1;
//            ArrayList<Distance> distanceArrayList = new ArrayList<>();
//            RouteMatrixResult routeMatrixResult;
//            for (Svc svc : svcArrayList) {
//                for (Slaughter slaughter : slaughterArrayList) {
//                    routeMatrixResult = gson.fromJson(HttpUtil.doGet(String.format(routeMatrixApi, svc.getLocation(), slaughter.getLocation())), RouteMatrixResult.class);
//                    if (null != routeMatrixResult && null != routeMatrixResult.getResult()) {
//                        distanceArrayList.add(new Distance(i++, svc.getId(), svc.getName(), slaughter.getId(), slaughter.getName(),
//                                routeMatrixResult.getResult().get(0).getDistance().getValue(), routeMatrixResult.getResult().get(0).getDistance().getText()));
////                        Distance distance = new Distance();
////                        distance.setId(i++);
////                        distance.setSvc_id(svc.getId());
////                        distance.setSvc_name(svc.getName());
////                        distance.setSlaughter_id(slaughter.getId());
////                        distance.setSlaughter_name(slaughter.getName());
////                        distance.setDistance(routeMatrixResult.getResult().get(0).getDistance().getValue());
////                        distance.setDistance_string(routeMatrixResult.getResult().get(0).getDistance().getText());
////                        distanceArrayList.add(distance);
//                    }
//                }
//            }
//            System.out.println(distanceArrayList);
////            DistanceMapper distanceMapper = sqlSession.getMapper(DistanceMapper.class);
////            distanceMapper.saveDistances(distanceArrayList);
////            sqlSession.commit();
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//    }
}
