package compare;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

/**
 * 将管理批次存栏和个体存栏分别保存在 inBatch 和 inPiggery 进行对比，找出有差异的猪只耳号
 *
 * @author 00137030
 * @date 2022/08/28
 */
public class CompareArrayList {

    /**
     * 从文件读入数据保存到 ArrayList
     *
     * @param filePath 输入文件路径
     * @return 保存了批次存栏流水信息的 ArrayList
     */
    private static ArrayList<String> readFile(String filePath) {
        // 暂存一行字符
        String s;
        // 创建 ArrayList ，用来保存每行数据所创建的对象
        ArrayList<String> stringArrayList = new ArrayList<>();
        try {
            // 文件字符输入流，可能存在 FileNotFoundException
            FileReader fileReader = new FileReader(filePath);
            // 缓冲区，有 readLine() 函数，方便使用
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            // 按行从文件读入，可能存在 IOException
            while ((s = bufferedReader.readLine()) != null) {
                // 去除每行的空白字符（空格和制表符）
                if ((s = s.replaceAll("\\s+", "")).length() > 0) {
                    // 每一行数据创建一个对象保存到 ArrayList 中
                    stringArrayList.add(s);
                }
            }
            // 关闭缓冲
            bufferedReader.close();
            // 关闭文件字符输入流
            fileReader.close();
        } catch (IOException e) {
            // 捕获可能出现 FileNotFoundException 和 IOException
            e.printStackTrace();
        }
        // 返回值未保存了批次存栏流水信息的 ArrayList
        return stringArrayList;
    }

    /**
     * ArrayList1 ∪ ArrayList2 - ArrayList1 ∩ ArrayList2
     *
     * @param list1 需要比较的 ArrayList
     * @param list2 需要比较的 ArrayList
     * @return 在 list1 中，但不在 list2 中的数据，和在 list2 中，但不在 list1 中的数据
     */
    private static ArrayList<ArrayList<String>> compareArrayList(ArrayList<String> list1, ArrayList<String> list2) {
        // 复制 list1
        ArrayList<String> t = new ArrayList<>(list1);
        // t = list1 ∩ list2
        t.retainAll(list2);
        // list1 = list1 - list1 ∩ list2
        list1.removeAll(t);
        // list2 = list2 - list1 ∩ list2
        list2.removeAll(t);
        // 结果保存到新的 ArrayList 中
        ArrayList<ArrayList<String>> arrayLists = new ArrayList<>(2);
        arrayLists.add(list1);
        arrayLists.add(list2);
        // 返回结果
        return arrayLists;
    }

    public static void main(String[] args) {
        String file1 = "C:\\Users\\00137030\\IdeaProjects\\HelloWorld\\src\\compare\\inBatch";
        String file2 = "C:\\Users\\00137030\\IdeaProjects\\HelloWorld\\src\\compare\\inPiggery";
        ArrayList<ArrayList<String>> compareResult = compareArrayList(readFile(file1), readFile(file2));
        System.out.println("在 inBatch 中但不在 inPiggery 中的数量为：" + compareResult.get(0).size() + '\n' +
                "详细耳号为：\n" + compareResult.get(0) + "\n\n" +
                "在 inPiggery 中但不在 inBatch 中的数量为：" + compareResult.get(1).size() + '\n' +
                "详细耳号为：\n" + compareResult.get(1));
    }
}
