/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithSource;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PossiblyInnerType;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceFile;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationUseSiteTarget;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationWithTarget;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.renderer.AnnotationArgumentsRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ClassifierNamePolicy;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererImpl$WhenMappings;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererModifier;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptionsImpl;
import kotlin.reflect.jvm.internal.impl.renderer.OverrideRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.ParameterNameRenderingPolicy;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingFormat;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.AbbreviatedType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.WrappedType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DescriptorRendererImpl
extends DescriptorRenderer
implements DescriptorRendererOptions {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy functionTypeAnnotationsRenderer$delegate;
    private final Lazy functionTypeParameterTypesRenderer$delegate;
    @NotNull
    private final DescriptorRendererOptionsImpl options;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DescriptorRendererImpl.class), "functionTypeAnnotationsRenderer", "getFunctionTypeAnnotationsRenderer()Lorg/jetbrains/kotlin/renderer/DescriptorRendererImpl;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DescriptorRendererImpl.class), "functionTypeParameterTypesRenderer", "getFunctionTypeParameterTypesRenderer()Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;"))};
    }

    private final DescriptorRendererImpl getFunctionTypeAnnotationsRenderer() {
        Lazy lazy = this.functionTypeAnnotationsRenderer$delegate;
        DescriptorRendererImpl descriptorRendererImpl = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (DescriptorRendererImpl)lazy.getValue();
    }

    private final DescriptorRenderer getFunctionTypeParameterTypesRenderer() {
        Lazy lazy = this.functionTypeParameterTypesRenderer$delegate;
        DescriptorRendererImpl descriptorRendererImpl = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (DescriptorRenderer)lazy.getValue();
    }

    private final String renderKeyword(String keyword) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                return keyword;
            }
            case 2: {
                return "<b>" + keyword + "</b>";
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final String renderError(String keyword) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$1[this.getTextFormat().ordinal()]) {
            case 1: {
                return keyword;
            }
            case 2: {
                return "<font color=red><b>" + keyword + "</b></font>";
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final String escape(String string) {
        return this.getTextFormat().escape(string);
    }

    private final String lt() {
        return this.escape("<");
    }

    private final String gt() {
        return this.escape(">");
    }

    private final String arrow() {
        String string;
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$2[this.getTextFormat().ordinal()]) {
            case 1: {
                string = this.escape("->");
                break;
            }
            case 2: {
                string = "&rarr;";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public String renderMessage(@NotNull String message) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$3[this.getTextFormat().ordinal()]) {
            case 1: {
                string = message;
                break;
            }
            case 2: {
                string = "<i>" + message + "</i>";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String renderName(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.escape(RenderingUtilsKt.render(name));
    }

    private final void renderName(DeclarationDescriptor descriptor2, StringBuilder builder) {
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"descriptor.name");
        builder.append(this.renderName(name));
    }

    private final void renderCompanionObjectName(DeclarationDescriptor descriptor2, StringBuilder builder) {
        if (this.getRenderCompanionObjectName()) {
            if (this.getStartFromName()) {
                builder.append("companion object");
            }
            this.renderSpaceIfNeeded(builder);
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            if (containingDeclaration != null) {
                builder.append("of ");
                Name name = containingDeclaration.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"containingDeclaration.name");
                builder.append(this.renderName(name));
            }
        }
        if (this.getVerbose() || Intrinsics.areEqual((Object)descriptor2.getName(), (Object)SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT) ^ true) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            Name name = descriptor2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"descriptor.name");
            builder.append(this.renderName(name));
        }
    }

    @Override
    @NotNull
    public String renderFqName(@NotNull FqNameUnsafe fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        List<Name> list = fqName2.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"fqName.pathSegments()");
        return this.renderFqName(list);
    }

    private final String renderFqName(List<Name> pathSegments) {
        return this.escape(RenderingUtilsKt.renderFqName(pathSegments));
    }

    @NotNull
    public String renderClassifierName(@NotNull ClassifierDescriptor klass) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        if (ErrorUtils.isError(klass)) {
            return klass.getTypeConstructor().toString();
        }
        return this.getClassifierNamePolicy().renderClassifier(klass, this);
    }

    @Override
    @NotNull
    public String renderType(@NotNull KotlinType type2) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        this.renderNormalizedType($receiver, (KotlinType)this.getTypeNormalizer().invoke((Object)type2));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void renderNormalizedType(@NotNull StringBuilder $receiver, KotlinType type2) {
        AbbreviatedType abbreviated;
        UnwrappedType unwrappedType = type2.unwrap();
        if (!(unwrappedType instanceof AbbreviatedType)) {
            unwrappedType = null;
        }
        if ((abbreviated = (AbbreviatedType)unwrappedType) != null) {
            this.renderNormalizedTypeAsIs($receiver, abbreviated.getAbbreviation());
            if (this.getRenderUnabbreviatedType()) {
                this.renderAbbreviatedTypeExpansion($receiver, abbreviated);
            }
            return;
        }
        this.renderNormalizedTypeAsIs($receiver, type2);
    }

    private final void renderAbbreviatedTypeExpansion(@NotNull StringBuilder $receiver, AbbreviatedType abbreviated) {
        if (this.getTextFormat() == RenderingFormat.HTML) {
            $receiver.append("<font color=\"808080\"><i>");
        }
        $receiver.append(" /* = ");
        this.renderNormalizedTypeAsIs($receiver, abbreviated.getExpandedType());
        $receiver.append(" */");
        if (this.getTextFormat() == RenderingFormat.HTML) {
            $receiver.append("</i></font>");
        }
    }

    private final void renderNormalizedTypeAsIs(@NotNull StringBuilder $receiver, KotlinType type2) {
        if (type2 instanceof WrappedType && this.getDebugMode() && !((WrappedType)type2).isComputed()) {
            $receiver.append("<Not computed yet>");
            return;
        }
        UnwrappedType unwrappedType = type2.unwrap();
        UnwrappedType unwrappedType2 = unwrappedType;
        if (unwrappedType2 instanceof FlexibleType) {
            $receiver.append(((FlexibleType)unwrappedType).render(this, this));
        } else if (unwrappedType2 instanceof SimpleType) {
            this.renderSimpleType($receiver, (SimpleType)unwrappedType);
        }
    }

    private final void renderSimpleType(@NotNull StringBuilder $receiver, SimpleType type2) {
        if (Intrinsics.areEqual((Object)type2, (Object)TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE) || TypeUtils.isDontCarePlaceholder(type2)) {
            $receiver.append("???");
            return;
        }
        if (ErrorUtils.isUninferredParameter(type2)) {
            if (this.getUninferredTypeParameterAsName()) {
                TypeConstructor typeConstructor2 = type2.getConstructor();
                if (typeConstructor2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.ErrorUtils.UninferredParameterTypeConstructor");
                }
                TypeParameterDescriptor typeParameterDescriptor = ((ErrorUtils.UninferredParameterTypeConstructor)typeConstructor2).getTypeParameterDescriptor();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"(type.constructor as Uni\u2026).typeParameterDescriptor");
                String string = typeParameterDescriptor.getName().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(type.constructor as Uni\u2026escriptor.name.toString()");
                $receiver.append(this.renderError(string));
            } else {
                $receiver.append("???");
            }
            return;
        }
        if (KotlinTypeKt.isError(type2)) {
            this.renderDefaultType($receiver, type2);
            return;
        }
        if (this.shouldRenderAsPrettyFunctionType(type2)) {
            this.renderFunctionType($receiver, type2);
        } else {
            this.renderDefaultType($receiver, type2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldRenderAsPrettyFunctionType(KotlinType type2) {
        Object element$iv;
        TypeProjection it;
        if (!FunctionTypesKt.isBuiltinFunctionalType(type2)) return false;
        Iterable $receiver$iv = type2.getArguments();
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (!(it = (TypeProjection)(element$iv = iterator2.next())).isStarProjection());
        return false;
    }

    @Override
    @NotNull
    public String renderFlexibleType(@NotNull String lowerRendered, @NotNull String upperRendered, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull((Object)lowerRendered, (String)"lowerRendered");
        Intrinsics.checkParameterIsNotNull((Object)upperRendered, (String)"upperRendered");
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        if (this.differsOnlyInNullability(lowerRendered, upperRendered)) {
            if (StringsKt.startsWith$default((String)upperRendered, (String)"(", (boolean)false, (int)2, null)) {
                return '(' + lowerRendered + ")!";
            }
            return lowerRendered + "!";
        }
        ClassifierNamePolicy classifierNamePolicy = this.getClassifierNamePolicy();
        ClassDescriptor classDescriptor = builtIns.getCollection();
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"builtIns.collection");
        String kotlinCollectionsPrefix = StringsKt.substringBefore$default((String)classifierNamePolicy.renderClassifier(classDescriptor, this), (String)"Collection", null, (int)2, null);
        String mutablePrefix = "Mutable";
        String simpleCollection = this.replacePrefixes(lowerRendered, kotlinCollectionsPrefix + mutablePrefix, upperRendered, kotlinCollectionsPrefix, kotlinCollectionsPrefix + '(' + mutablePrefix + ')');
        if (simpleCollection != null) {
            return simpleCollection;
        }
        String mutableEntry = this.replacePrefixes(lowerRendered, kotlinCollectionsPrefix + "MutableMap.MutableEntry", upperRendered, kotlinCollectionsPrefix + "Map.Entry", kotlinCollectionsPrefix + "(Mutable)Map.(Mutable)Entry");
        if (mutableEntry != null) {
            return mutableEntry;
        }
        ClassifierNamePolicy classifierNamePolicy2 = this.getClassifierNamePolicy();
        ClassDescriptor classDescriptor2 = builtIns.getArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"builtIns.array");
        String kotlinPrefix = StringsKt.substringBefore$default((String)classifierNamePolicy2.renderClassifier(classDescriptor2, this), (String)"Array", null, (int)2, null);
        String array = this.replacePrefixes(lowerRendered, kotlinPrefix + this.escape("Array<"), upperRendered, kotlinPrefix + this.escape("Array<out "), kotlinPrefix + this.escape("Array<(out) "));
        if (array != null) {
            return array;
        }
        return '(' + lowerRendered + ".." + upperRendered + ')';
    }

    @NotNull
    public String renderTypeArguments(@NotNull List<? extends TypeProjection> typeArguments) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(typeArguments, (String)"typeArguments");
        if (typeArguments.isEmpty()) {
            return "";
        }
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append(this.lt());
        this.appendTypeProjections($receiver, typeArguments);
        $receiver.append(this.gt());
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void renderDefaultType(@NotNull StringBuilder $receiver, KotlinType type2) {
        this.renderAnnotations($receiver, type2);
        if (KotlinTypeKt.isError(type2)) {
            $receiver.append(type2.getConstructor().toString());
            $receiver.append(this.renderTypeArguments(type2.getArguments()));
        } else {
            DescriptorRendererImpl.renderTypeConstructorAndArguments$default(this, $receiver, type2, null, 2, null);
        }
        if (type2.isMarkedNullable()) {
            $receiver.append("?");
        }
        if (SpecialTypesKt.isDefinitelyNotNullType(type2)) {
            $receiver.append("!!");
        }
    }

    private final void renderTypeConstructorAndArguments(@NotNull StringBuilder $receiver, KotlinType type2, TypeConstructor typeConstructor2) {
        PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(type2);
        if (possiblyInnerType == null) {
            $receiver.append(this.renderTypeConstructor(typeConstructor2));
            $receiver.append(this.renderTypeArguments(type2.getArguments()));
            return;
        }
        this.renderPossiblyInnerType($receiver, possiblyInnerType);
    }

    static /* bridge */ /* synthetic */ void renderTypeConstructorAndArguments$default(DescriptorRendererImpl descriptorRendererImpl, StringBuilder stringBuilder, KotlinType kotlinType, TypeConstructor typeConstructor2, int n, Object object) {
        if ((n & 2) != 0) {
            typeConstructor2 = kotlinType.getConstructor();
        }
        descriptorRendererImpl.renderTypeConstructorAndArguments(stringBuilder, kotlinType, typeConstructor2);
    }

    private final void renderPossiblyInnerType(@NotNull StringBuilder $receiver, PossiblyInnerType possiblyInnerType) {
        block3: {
            Object object;
            block2: {
                PossiblyInnerType possiblyInnerType2;
                object = possiblyInnerType.getOuterType();
                if (object == null) break block2;
                PossiblyInnerType it = possiblyInnerType2 = object;
                this.renderPossiblyInnerType($receiver, it);
                $receiver.append('.');
                Name name = possiblyInnerType.getClassifierDescriptor().getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"possiblyInnerType.classifierDescriptor.name");
                object = $receiver.append(this.renderName(name));
                if (object != null) break block3;
            }
            TypeConstructor typeConstructor2 = possiblyInnerType.getClassifierDescriptor().getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"possiblyInnerType.classi\u2026escriptor.typeConstructor");
            object = $receiver.append(this.renderTypeConstructor(typeConstructor2));
        }
        $receiver.append(this.renderTypeArguments(possiblyInnerType.getArguments()));
    }

    @NotNull
    public String renderTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
        String string;
        ClassifierDescriptor cd;
        Intrinsics.checkParameterIsNotNull((Object)typeConstructor2, (String)"typeConstructor");
        ClassifierDescriptor classifierDescriptor = cd = typeConstructor2.getDeclarationDescriptor();
        if (classifierDescriptor instanceof TypeParameterDescriptor || classifierDescriptor instanceof ClassDescriptor || classifierDescriptor instanceof TypeAliasDescriptor) {
            string = this.renderClassifierName(cd);
        } else if (classifierDescriptor == null) {
            string = typeConstructor2.toString();
        } else {
            String string2 = "Unexpected classifier: " + cd.getClass();
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    @Override
    @NotNull
    public String renderTypeProjection(@NotNull TypeProjection typeProjection) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)typeProjection, (String)"typeProjection");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        this.appendTypeProjections($receiver, CollectionsKt.listOf((Object)typeProjection));
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void appendTypeProjections(@NotNull StringBuilder $receiver, List<? extends TypeProjection> typeProjections) {
        CollectionsKt.joinTo$default((Iterable)typeProjections, (Appendable)$receiver, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<TypeProjection, CharSequence>(this){
            final /* synthetic */ DescriptorRendererImpl this$0;

            @NotNull
            public final CharSequence invoke(@NotNull TypeProjection it) {
                CharSequence charSequence;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (it.isStarProjection()) {
                    charSequence = "*";
                } else {
                    KotlinType kotlinType = it.getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"it.type");
                    String type2 = this.this$0.renderType(kotlinType);
                    charSequence = it.getProjectionKind() == Variance.INVARIANT ? type2 : (Object)((Object)it.getProjectionKind()) + ' ' + type2;
                }
                return charSequence;
            }
            {
                this.this$0 = descriptorRendererImpl;
                super(1);
            }
        }), (int)60, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderFunctionType(@NotNull StringBuilder $receiver, KotlinType type2) {
        boolean needParenthesis;
        DescriptorRendererImpl descriptorRendererImpl;
        int lengthBefore = $receiver.length();
        DescriptorRendererImpl $receiver2 = descriptorRendererImpl = this.getFunctionTypeAnnotationsRenderer();
        $receiver2.renderAnnotations($receiver, type2);
        boolean hasAnnotations = $receiver.length() != lengthBefore;
        boolean isSuspend = FunctionTypesKt.isSuspendFunctionType(type2);
        boolean isNullable = type2.isMarkedNullable();
        KotlinType receiverType = FunctionTypesKt.getReceiverTypeFromFunctionType(type2);
        boolean bl = needParenthesis = isNullable || hasAnnotations && receiverType != null;
        if (needParenthesis) {
            if (isSuspend) {
                $receiver.insert(lengthBefore, '(');
            } else {
                if (hasAnnotations) {
                    boolean bl2;
                    boolean bl3 = bl2 = StringsKt.last((CharSequence)$receiver) == ' ';
                    if (_Assertions.ENABLED && !bl2) {
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    if ($receiver.charAt(StringsKt.getLastIndex((CharSequence)$receiver) - 1) != ')') {
                        $receiver.insert(StringsKt.getLastIndex((CharSequence)$receiver), "()");
                    }
                }
                $receiver.append("(");
            }
        }
        this.renderModifier($receiver, isSuspend, "suspend");
        if (receiverType != null) {
            boolean surroundReceiver;
            boolean bl4 = surroundReceiver = this.shouldRenderAsPrettyFunctionType(receiverType) && !receiverType.isMarkedNullable() || this.hasModifiersOrAnnotations(receiverType);
            if (surroundReceiver) {
                $receiver.append("(");
            }
            this.renderNormalizedType($receiver, receiverType);
            if (surroundReceiver) {
                $receiver.append(")");
            }
            $receiver.append(".");
        }
        $receiver.append("(");
        List<TypeProjection> parameterTypes = FunctionTypesKt.getValueParameterTypesFromFunctionType(type2);
        boolean bl5 = false;
        for (TypeProjection typeProjection : (Iterable)parameterTypes) {
            Name name;
            Name name2;
            void index;
            if (index > 0) {
                $receiver.append(", ");
            }
            if (this.getParameterNamesInFunctionalTypes()) {
                KotlinType kotlinType = typeProjection.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"typeProjection.type");
                name2 = FunctionTypesKt.extractParameterNameFromFunctionTypeArgument(kotlinType);
            } else {
                name2 = name = null;
            }
            if (name != null) {
                $receiver.append(this.renderName(name));
                $receiver.append(": ");
            }
            $receiver.append(this.getFunctionTypeParameterTypesRenderer().renderTypeProjection(typeProjection));
            ++index;
        }
        $receiver.append(") ").append(this.arrow()).append(" ");
        this.renderNormalizedType($receiver, FunctionTypesKt.getReturnTypeFromFunctionType(type2));
        if (needParenthesis) {
            $receiver.append(")");
        }
        if (isNullable) {
            $receiver.append("?");
        }
    }

    private final boolean hasModifiersOrAnnotations(@NotNull KotlinType $receiver) {
        return FunctionTypesKt.isSuspendFunctionType($receiver) || !$receiver.getAnnotations().isEmpty();
    }

    private final void appendDefinedIn(@NotNull StringBuilder $receiver, DeclarationDescriptor descriptor2) {
        block4: {
            FqNameUnsafe fqName2;
            if (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof PackageViewDescriptor) {
                return;
            }
            if (descriptor2 instanceof ModuleDescriptor) {
                $receiver.append(" is a module");
                return;
            }
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            if (containingDeclaration == null || containingDeclaration instanceof ModuleDescriptor) break block4;
            $receiver.append(" ").append(this.renderMessage("defined in")).append(" ");
            FqNameUnsafe fqNameUnsafe = fqName2 = DescriptorUtils.getFqName(containingDeclaration);
            Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"fqName");
            $receiver.append(fqNameUnsafe.isRoot() ? "root package" : this.renderFqName(fqName2));
            if (this.getWithSourceFileForTopLevel() && containingDeclaration instanceof PackageFragmentDescriptor && descriptor2 instanceof DeclarationDescriptorWithSource) {
                SourceElement sourceElement = ((DeclarationDescriptorWithSource)descriptor2).getSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"descriptor.source");
                SourceFile sourceFile = sourceElement.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceFile, (String)"descriptor.source.containingFile");
                String string = sourceFile.getName();
                if (string != null) {
                    String string2;
                    String sourceFileName = string2 = string;
                    $receiver.append(" ").append(this.renderMessage("in file")).append(" ").append(sourceFileName);
                }
            }
        }
    }

    private final void renderAnnotations(@NotNull StringBuilder $receiver, Annotated annotated) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS)) {
            return;
        }
        Set<FqName> excluded = annotated instanceof KotlinType ? this.getExcludedTypeAnnotationClasses() : this.getExcludedAnnotationClasses();
        Function1<AnnotationDescriptor, Boolean> annotationFilter = this.getAnnotationFilter();
        for (AnnotationWithTarget annotationWithTarget : annotated.getAnnotations().getAllAnnotations()) {
            AnnotationDescriptor annotation = annotationWithTarget.component1();
            AnnotationUseSiteTarget target = annotationWithTarget.component2();
            if (CollectionsKt.contains((Iterable)excluded, (Object)annotation.getFqName()) || annotationFilter != null && !((Boolean)annotationFilter.invoke((Object)annotation)).booleanValue()) continue;
            $receiver.append(this.renderAnnotation(annotation, target)).append(" ");
        }
    }

    @Override
    @NotNull
    public String renderAnnotation(@NotNull AnnotationDescriptor annotation, @Nullable AnnotationUseSiteTarget target) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append('@');
        if (target != null) {
            $receiver.append(target.getRenderName() + ":");
        }
        KotlinType annotationType = annotation.getType();
        $receiver.append(this.renderType(annotationType));
        if (this.getIncludeAnnotationArguments()) {
            Collection collection;
            List<String> arguments2 = this.renderAndSortAnnotationArguments(annotation);
            if (this.getIncludeEmptyAnnotationArguments() || !(collection = (Collection)arguments2).isEmpty()) {
                CollectionsKt.joinTo$default((Iterable)arguments2, (Appendable)$receiver, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)112, null);
            }
        }
        if (this.getVerbose() && (KotlinTypeKt.isError(annotationType) || annotationType.getConstructor().getDeclarationDescriptor() instanceof NotFoundClasses.MockClassDescriptor)) {
            $receiver.append(" /* annotation class not found */");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> renderAndSortAnnotationArguments(AnnotationDescriptor descriptor2) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Name it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        List list;
        Iterable iterable;
        Object object;
        Iterable iterable2;
        Object item$iv$iv2;
        Iterable destination$iv$iv;
        Iterable $receiver$iv3;
        Map<Name, ConstantValue<?>> allValueArguments2 = descriptor2.getAllValueArguments();
        ClassDescriptor classDescriptor = this.getRenderDefaultAnnotationArguments() ? DescriptorUtilsKt.getAnnotationClass(descriptor2) : null;
        Object object2 = classDescriptor;
        if (object2 != null && (object2 = object2.getUnsubstitutedPrimaryConstructor()) != null && (object2 = object2.getValueParameters()) != null) {
            ValueParameterDescriptor it2;
            Iterable $receiver$iv$iv3;
            Iterable iterable3 = (Iterable)object2;
            List list2 = $receiver$iv3;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv3) {
                it2 = (ValueParameterDescriptor)element$iv$iv;
                if (!it2.declaresDefaultValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv3 = (List)destination$iv$iv;
            $receiver$iv$iv3 = $receiver$iv3;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv3) {
                it2 = (ValueParameterDescriptor)item$iv$iv2;
                iterable2 = destination$iv$iv;
                ValueParameterDescriptor valueParameterDescriptor = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
                object = valueParameterDescriptor.getName();
                iterable2.add(object);
            }
            iterable = (List)destination$iv$iv;
        } else {
            iterable = $receiver$iv3 = null;
        }
        if ((list = $receiver$iv3) == null) {
            list = CollectionsKt.emptyList();
        }
        List parameterDescriptorsWithDefaultValue = list;
        destination$iv$iv = $receiver$iv2 = (Iterable)parameterDescriptorsWithDefaultValue;
        Collection destination$iv$iv2 = new ArrayList();
        item$iv$iv2 = $receiver$iv$iv2.iterator();
        while (item$iv$iv2.hasNext()) {
            Map<Name, ConstantValue<?>> $i$f$mapTo = allValueArguments2;
            Map<Name, ConstantValue<?>> $i$f$map = $i$f$mapTo;
            Object element$iv$iv = item$iv$iv2.next();
            it = (Name)element$iv$iv;
            if (!(!$i$f$map.containsKey(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv3 : $receiver$iv$iv2) {
            it = (Name)item$iv$iv3;
            iterable2 = destination$iv$iv2;
            object = it.asString() + " = ...";
            iterable2.add(object);
        }
        List defaultList = (List)destination$iv$iv2;
        $receiver$iv$iv2 = allValueArguments2.entrySet();
        destination$iv$iv2 = $receiver$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv4 : $receiver$iv$iv) {
            void $name_value;
            Map.Entry $i$a$2$map = (Map.Entry)item$iv$iv4;
            iterable2 = destination$iv$iv3;
            void var13_15 = $name_value;
            Name name = (Name)var13_15.getKey();
            var13_15 = $name_value;
            ConstantValue value = (ConstantValue)var13_15.getValue();
            object = name.asString() + " = " + (!parameterDescriptorsWithDefaultValue.contains(name) ? this.renderConstant(value) : "...");
            iterable2.add(object);
        }
        List argumentList = (List)destination$iv$iv3;
        return CollectionsKt.sorted((Iterable)CollectionsKt.plus((Collection)defaultList, (Iterable)argumentList));
    }

    private final String renderConstant(ConstantValue<?> value) {
        ConstantValue<?> constantValue = value;
        return constantValue instanceof ArrayValue ? CollectionsKt.joinToString$default((Iterable)((Iterable)((ArrayValue)value).getValue()), (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)new Function1<ConstantValue<?>, String>(this){
            final /* synthetic */ DescriptorRendererImpl this$0;

            @NotNull
            public final String invoke(@NotNull ConstantValue<?> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return DescriptorRendererImpl.access$renderConstant(this.this$0, it);
            }
            {
                this.this$0 = descriptorRendererImpl;
                super(1);
            }
        }, (int)24, null) : (constantValue instanceof AnnotationValue ? StringsKt.removePrefix((String)DescriptorRenderer.renderAnnotation$default(this, (AnnotationDescriptor)((AnnotationValue)value).getValue(), null, 2, null), (CharSequence)"@") : (constantValue instanceof KClassValue ? this.renderType(((KClassValue)value).getValue()) + "::class" : value.toString()));
    }

    private final void renderVisibility(Visibility visibility, StringBuilder builder) {
        Visibility visibility2 = visibility;
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.VISIBILITY)) {
            return;
        }
        if (this.getNormalizedVisibilities()) {
            visibility2 = visibility2.normalize();
        }
        if (!this.getRenderDefaultVisibility() && Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.DEFAULT_VISIBILITY)) {
            return;
        }
        builder.append(this.renderKeyword(visibility2.getDisplayName())).append(" ");
    }

    private final void renderModality(Modality modality, StringBuilder builder) {
        String string = modality.name();
        boolean bl = this.getModifiers().contains((Object)DescriptorRendererModifier.MODALITY);
        StringBuilder stringBuilder = builder;
        DescriptorRendererImpl descriptorRendererImpl = this;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        descriptorRendererImpl.renderModifier(stringBuilder, bl, string4);
    }

    private final void renderModalityForCallable(CallableMemberDescriptor callable, StringBuilder builder) {
        if (!DescriptorUtils.isTopLevelDeclaration(callable) || callable.getModality() != Modality.FINAL) {
            if (this.getOverrideRenderingPolicy() == OverrideRenderingPolicy.RENDER_OVERRIDE && callable.getModality() == Modality.OPEN && this.overridesSomething(callable)) {
                return;
            }
            Modality modality = callable.getModality();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)modality), (String)"callable.modality");
            this.renderModality(modality, builder);
        }
    }

    private final void renderOverride(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.OVERRIDE)) {
            return;
        }
        if (this.overridesSomething(callableMember) && this.getOverrideRenderingPolicy() != OverrideRenderingPolicy.RENDER_OPEN) {
            this.renderModifier(builder, true, "override");
            if (this.getVerbose()) {
                builder.append("/*").append(callableMember.getOverriddenDescriptors().size()).append("*/ ");
            }
        }
    }

    private final void renderMemberKind(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (!this.getModifiers().contains((Object)DescriptorRendererModifier.MEMBER_KIND)) {
            return;
        }
        if (this.getVerbose() && callableMember.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            String string = callableMember.getKind().name();
            StringBuilder stringBuilder = builder.append("/*");
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            String string4 = string3;
            stringBuilder.append(string4).append("*/ ");
        }
    }

    private final void renderModifier(StringBuilder builder, boolean value, String modifier) {
        if (value) {
            builder.append(this.renderKeyword(modifier));
            builder.append(" ");
        }
    }

    private final void renderMemberModifiers(MemberDescriptor descriptor2, StringBuilder builder) {
        this.renderModifier(builder, descriptor2.isExternal(), "external");
        this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.EXPECT) && descriptor2.isExpect(), "expect");
        this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.ACTUAL) && descriptor2.isActual(), "actual");
    }

    /*
     * Unable to fully structure code
     */
    private final void renderAdditionalModifiers(FunctionDescriptor functionDescriptor, StringBuilder builder) {
        block11: {
            block10: {
                if (!functionDescriptor.isOperator()) ** GOTO lbl-1000
                v0 = functionDescriptor.getOverriddenDescriptors();
                Intrinsics.checkExpressionValueIsNotNull(v0, (String)"functionDescriptor.overriddenDescriptors");
                $receiver$iv = v0;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    v1 = true;
                } else {
                    for (T element$iv : $receiver$iv) {
                        v2 = it = (FunctionDescriptor)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                        if (!v2.isOperator()) continue;
                        v1 = false;
                        break block10;
                    }
                    v1 = true;
                }
            }
            if (v1 || this.getAlwaysRenderModifiers()) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = isOperator = false;
            }
            if (!functionDescriptor.isInfix()) ** GOTO lbl-1000
            v4 = functionDescriptor.getOverriddenDescriptors();
            Intrinsics.checkExpressionValueIsNotNull(v4, (String)"functionDescriptor.overriddenDescriptors");
            $receiver$iv = v4;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                v5 = true;
            } else {
                for (T element$iv : $receiver$iv) {
                    v6 = it = (FunctionDescriptor)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
                    if (!v6.isInfix()) continue;
                    v5 = false;
                    break block11;
                }
                v5 = true;
            }
        }
        if (v5 || this.getAlwaysRenderModifiers()) {
            v7 = true;
        } else lbl-1000:
        // 2 sources

        {
            v7 = false;
        }
        isInfix = v7;
        this.renderModifier(builder, functionDescriptor.isTailrec(), "tailrec");
        this.renderSuspendModifier(functionDescriptor, builder);
        this.renderModifier(builder, functionDescriptor.isInline(), "inline");
        this.renderModifier(builder, isInfix, "infix");
        this.renderModifier(builder, isOperator, "operator");
    }

    private final void renderSuspendModifier(FunctionDescriptor functionDescriptor, StringBuilder builder) {
        this.renderModifier(builder, functionDescriptor.isSuspend(), "suspend");
    }

    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor declarationDescriptor) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)declarationDescriptor, (String)"declarationDescriptor");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        declarationDescriptor.accept(new RenderDeclarationDescriptorVisitor(), $receiver);
        if (this.getWithDefinedIn()) {
            this.appendDefinedIn($receiver, declarationDescriptor);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void renderTypeParameter(TypeParameterDescriptor typeParameter, StringBuilder builder, boolean topLevel) {
        if (topLevel) {
            builder.append(this.lt());
        }
        if (this.getVerbose()) {
            builder.append("/*").append(typeParameter.getIndex()).append("*/ ");
        }
        this.renderModifier(builder, typeParameter.isReified(), "reified");
        String variance = typeParameter.getVariance().getLabel();
        CharSequence charSequence = variance;
        StringBuilder stringBuilder = builder;
        DescriptorRendererImpl descriptorRendererImpl = this;
        boolean bl = charSequence.length() > 0;
        descriptorRendererImpl.renderModifier(stringBuilder, bl, variance);
        this.renderAnnotations(builder, typeParameter);
        this.renderName(typeParameter, builder);
        int upperBoundsCount = typeParameter.getUpperBounds().size();
        if (upperBoundsCount > 1 && !topLevel || upperBoundsCount == 1) {
            KotlinType upperBound = typeParameter.getUpperBounds().iterator().next();
            if (!KotlinBuiltIns.isDefaultBound(upperBound)) {
                StringBuilder stringBuilder2 = builder.append(" : ");
                KotlinType kotlinType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"upperBound");
                stringBuilder2.append(this.renderType(kotlinType));
            }
        } else if (topLevel) {
            boolean first = true;
            for (KotlinType upperBound : typeParameter.getUpperBounds()) {
                if (KotlinBuiltIns.isDefaultBound(upperBound)) continue;
                if (first) {
                    builder.append(" : ");
                } else {
                    builder.append(" & ");
                }
                KotlinType kotlinType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"upperBound");
                builder.append(this.renderType(kotlinType));
                first = false;
            }
        }
        if (topLevel) {
            builder.append(this.gt());
        }
    }

    private final void renderTypeParameters(List<? extends TypeParameterDescriptor> typeParameters2, StringBuilder builder, boolean withSpace) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        if (!typeParameters2.isEmpty()) {
            builder.append(this.lt());
            this.renderTypeParameterList(builder, typeParameters2);
            builder.append(this.gt());
            if (withSpace) {
                builder.append(" ");
            }
        }
    }

    private final void renderTypeParameterList(StringBuilder builder, List<? extends TypeParameterDescriptor> typeParameters2) {
        Iterator<? extends TypeParameterDescriptor> iterator2 = typeParameters2.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor = iterator2.next();
            this.renderTypeParameter(typeParameterDescriptor, builder, false);
            if (!iterator2.hasNext()) continue;
            builder.append(", ");
        }
    }

    private final void renderFunction(FunctionDescriptor function, StringBuilder builder) {
        if (!this.getStartFromName()) {
            if (!this.getStartFromDeclarationKeyword()) {
                this.renderAnnotations(builder, function);
                Visibility visibility = function.getVisibility();
                Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"function.visibility");
                this.renderVisibility(visibility, builder);
                this.renderModalityForCallable(function, builder);
                if (this.getIncludeAdditionalModifiers()) {
                    this.renderMemberModifiers(function, builder);
                }
                this.renderOverride(function, builder);
                if (this.getIncludeAdditionalModifiers()) {
                    this.renderAdditionalModifiers(function, builder);
                } else {
                    this.renderSuspendModifier(function, builder);
                }
                this.renderMemberKind(function, builder);
                if (this.getVerbose()) {
                    if (function.isHiddenToOvercomeSignatureClash()) {
                        builder.append("/*isHiddenToOvercomeSignatureClash*/ ");
                    }
                    if (function.isHiddenForResolutionEverywhereBesideSupercalls()) {
                        builder.append("/*isHiddenForResolutionEverywhereBesideSupercalls*/ ");
                    }
                }
            }
            builder.append(this.renderKeyword("fun")).append(" ");
            List<TypeParameterDescriptor> list = function.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"function.typeParameters");
            this.renderTypeParameters(list, builder, true);
            this.renderReceiver(function, builder);
        }
        this.renderName(function, builder);
        List<ValueParameterDescriptor> list = function.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"function.valueParameters");
        this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)list, function.hasSynthesizedParameterNames(), builder);
        this.renderReceiverAfterName(function, builder);
        KotlinType returnType = function.getReturnType();
        if (!(this.getWithoutReturnType() || !this.getUnitReturnType() && returnType != null && KotlinBuiltIns.isUnit(returnType))) {
            builder.append(": ").append(returnType == null ? "[NULL]" : this.renderType(returnType));
        }
        List<TypeParameterDescriptor> list2 = function.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"function.typeParameters");
        this.renderWhereSuffix(list2, builder);
    }

    private final void renderReceiverAfterName(CallableDescriptor callableDescriptor, StringBuilder builder) {
        if (!this.getReceiverAfterName()) {
            return;
        }
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            StringBuilder stringBuilder = builder.append(" on ");
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiver.type");
            stringBuilder.append(this.renderType(kotlinType));
        }
    }

    private final void renderReceiver(CallableDescriptor callableDescriptor, StringBuilder builder) {
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            KotlinType type2;
            KotlinType kotlinType = type2 = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"type");
            String result = this.renderType(kotlinType);
            if (this.shouldRenderAsPrettyFunctionType(type2) && !TypeUtils.isNullableType(type2)) {
                result = '(' + result + ')';
            }
            builder.append(result).append(".");
        }
    }

    private final void renderConstructor(ConstructorDescriptor constructor, StringBuilder builder) {
        this.renderAnnotations(builder, constructor);
        Visibility visibility = constructor.getVisibility();
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"constructor.visibility");
        this.renderVisibility(visibility, builder);
        this.renderMemberKind(constructor, builder);
        if (this.getRenderConstructorKeyword()) {
            builder.append(this.renderKeyword("constructor"));
        }
        if (this.getSecondaryConstructorsAsPrimary()) {
            ClassifierDescriptorWithTypeParameters classDescriptor = constructor.getContainingDeclaration();
            if (this.getRenderConstructorKeyword()) {
                builder.append(" ");
            }
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptorWithTypeParameters, (String)"classDescriptor");
            this.renderName(classifierDescriptorWithTypeParameters, builder);
            List<TypeParameterDescriptor> list = constructor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"constructor.typeParameters");
            this.renderTypeParameters(list, builder, false);
        }
        List<ValueParameterDescriptor> list = constructor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"constructor.valueParameters");
        this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)list, constructor.hasSynthesizedParameterNames(), builder);
        if (this.getSecondaryConstructorsAsPrimary()) {
            List<TypeParameterDescriptor> list2 = constructor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"constructor.typeParameters");
            this.renderWhereSuffix(list2, builder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderWhereSuffix(List<? extends TypeParameterDescriptor> typeParameters2, StringBuilder builder) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        ArrayList upperBoundStrings = new ArrayList(0);
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters2) {
            void $receiver$iv;
            List<KotlinType> list = typeParameterDescriptor.getUpperBounds();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"typeParameter.upperBounds");
            Iterable iterable = CollectionsKt.drop((Iterable)list, (int)1);
            for (Object item$iv : $receiver$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv;
                Collection collection = upperBoundStrings;
                StringBuilder stringBuilder = new StringBuilder();
                Name name = typeParameterDescriptor.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"typeParameter.name");
                StringBuilder stringBuilder2 = stringBuilder.append(this.renderName(name)).append(" : ");
                void v4 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                String string = stringBuilder2.append(this.renderType((KotlinType)v4)).toString();
                collection.add(string);
            }
        }
        if (!upperBoundStrings.isEmpty()) {
            builder.append(" ").append(this.renderKeyword("where")).append(" ");
            CollectionsKt.joinTo$default((Iterable)upperBoundStrings, (Appendable)builder, (CharSequence)", ", null, null, (int)0, null, null, (int)124, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderValueParameters(Collection<? extends ValueParameterDescriptor> parameters2, boolean synthesizedParameterNames, StringBuilder builder) {
        boolean includeNames = this.shouldRenderParameterNames(synthesizedParameterNames);
        int parameterCount = parameters2.size();
        this.getValueParametersHandler().appendBeforeValueParameters(parameterCount, builder);
        boolean bl = false;
        for (ValueParameterDescriptor parameter : (Iterable)parameters2) {
            void index;
            this.getValueParametersHandler().appendBeforeValueParameter(parameter, (int)index, parameterCount, builder);
            this.renderValueParameter(parameter, includeNames, builder, false);
            this.getValueParametersHandler().appendAfterValueParameter(parameter, (int)index, parameterCount, builder);
            ++index;
        }
        this.getValueParametersHandler().appendAfterValueParameters(parameterCount, builder);
    }

    private final boolean shouldRenderParameterNames(boolean synthesizedParameterNames) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$4[this.getParameterNameRenderingPolicy().ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                return !synthesizedParameterNames;
            }
            case 3: {
                return false;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final void renderValueParameter(ValueParameterDescriptor valueParameter, boolean includeName, StringBuilder builder, boolean topLevel) {
        boolean withDefaultValue;
        if (topLevel) {
            builder.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.getVerbose()) {
            builder.append("/*").append(valueParameter.getIndex()).append("*/ ");
        }
        this.renderAnnotations(builder, valueParameter);
        this.renderModifier(builder, valueParameter.isCrossinline(), "crossinline");
        this.renderModifier(builder, valueParameter.isNoinline(), "noinline");
        this.renderVariable(valueParameter, includeName, builder, topLevel);
        boolean bl = this.getDefaultParameterValueRenderer() != null && (this.getDebugMode() ? valueParameter.declaresDefaultValue() : DescriptorUtilsKt.declaresOrInheritsDefaultValue(valueParameter)) ? true : (withDefaultValue = false);
        if (withDefaultValue) {
            StringBuilder stringBuilder = new StringBuilder().append(" = ");
            Function1<ValueParameterDescriptor, String> function1 = this.getDefaultParameterValueRenderer();
            if (function1 == null) {
                Intrinsics.throwNpe();
            }
            builder.append(stringBuilder.append((String)function1.invoke((Object)valueParameter)).toString());
        }
    }

    private final void renderValVarPrefix(VariableDescriptor variable, StringBuilder builder) {
        if (!(variable instanceof ValueParameterDescriptor)) {
            builder.append(this.renderKeyword(variable.isVar() ? "var" : "val")).append(" ");
        }
    }

    private final void renderVariable(VariableDescriptor variable, boolean includeName, StringBuilder builder, boolean topLevel) {
        KotlinType realType = variable.getType();
        VariableDescriptor variableDescriptor = variable;
        if (!(variableDescriptor instanceof ValueParameterDescriptor)) {
            variableDescriptor = null;
        }
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)variableDescriptor;
        KotlinType varargElementType = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
        KotlinType kotlinType = varargElementType;
        if (kotlinType == null) {
            KotlinType kotlinType2 = realType;
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"realType");
        }
        KotlinType typeToRender = kotlinType;
        this.renderModifier(builder, varargElementType != null, "vararg");
        if (topLevel && !this.getStartFromName()) {
            this.renderValVarPrefix(variable, builder);
        }
        if (includeName) {
            this.renderName(variable, builder);
            builder.append(": ");
        }
        builder.append(this.renderType(typeToRender));
        this.renderInitializer(variable, builder);
        if (this.getVerbose() && varargElementType != null) {
            StringBuilder stringBuilder = builder.append(" /*");
            KotlinType kotlinType3 = realType;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"realType");
            stringBuilder.append(this.renderType(kotlinType3)).append("*/");
        }
    }

    private final void renderProperty(PropertyDescriptor property, StringBuilder builder) {
        if (!this.getStartFromName()) {
            if (!this.getStartFromDeclarationKeyword()) {
                this.renderAnnotations(builder, property);
                Visibility visibility = property.getVisibility();
                Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"property.visibility");
                this.renderVisibility(visibility, builder);
                this.renderModifier(builder, property.isConst(), "const");
                this.renderMemberModifiers(property, builder);
                this.renderModalityForCallable(property, builder);
                this.renderOverride(property, builder);
                this.renderModifier(builder, property.isLateInit(), "lateinit");
                this.renderMemberKind(property, builder);
            }
            this.renderValVarPrefix(property, builder);
            List<TypeParameterDescriptor> list = property.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"property.typeParameters");
            this.renderTypeParameters(list, builder, true);
            this.renderReceiver(property, builder);
        }
        this.renderName(property, builder);
        StringBuilder stringBuilder = builder.append(": ");
        KotlinType kotlinType = property.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"property.type");
        stringBuilder.append(this.renderType(kotlinType));
        this.renderReceiverAfterName(property, builder);
        this.renderInitializer(property, builder);
        List<TypeParameterDescriptor> list = property.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"property.typeParameters");
        this.renderWhereSuffix(list, builder);
    }

    private final void renderInitializer(VariableDescriptor variable, StringBuilder builder) {
        block1: {
            if (!this.getIncludePropertyConstant()) break block1;
            ConstantValue<?> constantValue = variable.getCompileTimeInitializer();
            if (constantValue != null) {
                ConstantValue<?> constantValue2;
                ConstantValue<?> constant = constantValue2 = constantValue;
                StringBuilder stringBuilder = builder.append(" = ");
                ConstantValue<?> constantValue3 = constant;
                Intrinsics.checkExpressionValueIsNotNull(constantValue3, (String)"constant");
                stringBuilder.append(this.escape(this.renderConstant(constantValue3)));
            }
        }
    }

    private final void renderTypeAlias(TypeAliasDescriptor typeAlias, StringBuilder builder) {
        this.renderAnnotations(builder, typeAlias);
        Visibility visibility = typeAlias.getVisibility();
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"typeAlias.visibility");
        this.renderVisibility(visibility, builder);
        this.renderMemberModifiers(typeAlias, builder);
        builder.append(this.renderKeyword("typealias")).append(" ");
        this.renderName(typeAlias, builder);
        List<TypeParameterDescriptor> list = typeAlias.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"typeAlias.declaredTypeParameters");
        this.renderTypeParameters(list, builder, false);
        this.renderCapturedTypeParametersIfRequired(typeAlias, builder);
        builder.append(" = ").append(this.renderType(typeAlias.getUnderlyingType()));
    }

    private final void renderCapturedTypeParametersIfRequired(ClassifierDescriptorWithTypeParameters classifier2, StringBuilder builder) {
        List<TypeParameterDescriptor> typeParameters2 = classifier2.getDeclaredTypeParameters();
        TypeConstructor typeConstructor2 = classifier2.getTypeConstructor();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"classifier.typeConstructor");
        List<TypeParameterDescriptor> typeConstructorParameters = typeConstructor2.getParameters();
        if (this.getVerbose() && classifier2.isInner() && typeConstructorParameters.size() > typeParameters2.size()) {
            builder.append(" /*captured type parameters: ");
            this.renderTypeParameterList(builder, typeConstructorParameters.subList(typeParameters2.size(), typeConstructorParameters.size()));
            builder.append("*/");
        }
    }

    private final void renderClass(ClassDescriptor klass, StringBuilder builder) {
        ClassConstructorDescriptor primaryConstructor2;
        List<TypeParameterDescriptor> typeParameters2;
        boolean isEnumEntry;
        boolean bl = isEnumEntry = klass.getKind() == ClassKind.ENUM_ENTRY;
        if (!this.getStartFromName()) {
            this.renderAnnotations(builder, klass);
            if (!isEnumEntry) {
                Visibility visibility = klass.getVisibility();
                Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"klass.visibility");
                this.renderVisibility(visibility, builder);
            }
            if (klass.getKind() != ClassKind.INTERFACE || klass.getModality() != Modality.ABSTRACT) {
                ClassKind classKind = klass.getKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)classKind), (String)"klass.kind");
                if (!classKind.isSingleton() || klass.getModality() != Modality.FINAL) {
                    Modality modality = klass.getModality();
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)modality), (String)"klass.modality");
                    this.renderModality(modality, builder);
                }
            }
            this.renderMemberModifiers(klass, builder);
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.INNER) && klass.isInner(), "inner");
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.DATA) && klass.isData(), "data");
            this.renderModifier(builder, this.getModifiers().contains((Object)DescriptorRendererModifier.INLINE) && klass.isInline(), "inline");
            this.renderClassKindPrefix(klass, builder);
        }
        if (!DescriptorUtils.isCompanionObject(klass)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            this.renderName(klass, builder);
        } else {
            this.renderCompanionObjectName(klass, builder);
        }
        if (isEnumEntry) {
            return;
        }
        List<TypeParameterDescriptor> list = typeParameters2 = klass.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"typeParameters");
        this.renderTypeParameters(list, builder, false);
        this.renderCapturedTypeParametersIfRequired(klass, builder);
        ClassKind classKind = klass.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)classKind), (String)"klass.kind");
        if (!classKind.isSingleton() && this.getClassWithPrimaryConstructor() && (primaryConstructor2 = klass.getUnsubstitutedPrimaryConstructor()) != null) {
            builder.append(" ");
            this.renderAnnotations(builder, primaryConstructor2);
            Visibility visibility = primaryConstructor2.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"primaryConstructor.visibility");
            this.renderVisibility(visibility, builder);
            builder.append(this.renderKeyword("constructor"));
            List<ValueParameterDescriptor> list2 = primaryConstructor2.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"primaryConstructor.valueParameters");
            this.renderValueParameters((Collection<? extends ValueParameterDescriptor>)list2, primaryConstructor2.hasSynthesizedParameterNames(), builder);
        }
        this.renderSuperTypes(klass, builder);
        this.renderWhereSuffix(typeParameters2, builder);
    }

    private final void renderSuperTypes(ClassDescriptor klass, StringBuilder builder) {
        if (this.getWithoutSuperTypes()) {
            return;
        }
        if (KotlinBuiltIns.isNothing(klass.getDefaultType())) {
            return;
        }
        TypeConstructor typeConstructor2 = klass.getTypeConstructor();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"klass.typeConstructor");
        Collection<KotlinType> supertypes2 = typeConstructor2.getSupertypes();
        if (supertypes2.isEmpty() || supertypes2.size() == 1 && KotlinBuiltIns.isAnyOrNullableAny(supertypes2.iterator().next())) {
            return;
        }
        this.renderSpaceIfNeeded(builder);
        builder.append(": ");
        Collection<KotlinType> collection = supertypes2;
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"supertypes");
        CollectionsKt.joinTo$default((Iterable)collection, (Appendable)builder, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<KotlinType, String>(this){
            final /* synthetic */ DescriptorRendererImpl this$0;

            @NotNull
            public final String invoke(KotlinType it) {
                KotlinType kotlinType = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"it");
                return this.this$0.renderType(kotlinType);
            }
            {
                this.this$0 = descriptorRendererImpl;
                super(1);
            }
        }), (int)60, null);
    }

    private final void renderClassKindPrefix(ClassDescriptor klass, StringBuilder builder) {
        builder.append(this.renderKeyword(DescriptorRenderer.Companion.getClassifierKindPrefix(klass)));
    }

    private final void renderPackageView(PackageViewDescriptor packageView, StringBuilder builder) {
        this.renderPackageHeader(packageView.getFqName(), "package", builder);
        if (this.getDebugMode()) {
            builder.append(" in context of ");
            this.renderName(packageView.getModule(), builder);
        }
    }

    private final void renderPackageFragment(PackageFragmentDescriptor fragment, StringBuilder builder) {
        this.renderPackageHeader(fragment.getFqName(), "package-fragment", builder);
        if (this.getDebugMode()) {
            builder.append(" in ");
            this.renderName(fragment.getContainingDeclaration(), builder);
        }
    }

    private final void renderPackageHeader(FqName fqName2, String fragmentOrView, StringBuilder builder) {
        builder.append(this.renderKeyword(fragmentOrView));
        FqNameUnsafe fqNameUnsafe = fqName2.toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"fqName.toUnsafe()");
        String fqNameString = this.renderFqName(fqNameUnsafe);
        CharSequence charSequence = fqNameString;
        if (charSequence.length() > 0) {
            builder.append(" ");
            builder.append(fqNameString);
        }
    }

    private final void renderAccessorModifiers(PropertyAccessorDescriptor descriptor2, StringBuilder builder) {
        this.renderMemberModifiers(descriptor2, builder);
    }

    private final void renderSpaceIfNeeded(StringBuilder builder) {
        int length = builder.length();
        if (length == 0 || builder.charAt(length - 1) != ' ') {
            builder.append(' ');
        }
    }

    private final String replacePrefixes(String lowerRendered, String lowerPrefix, String upperRendered, String upperPrefix, String foldedPrefix) {
        if (StringsKt.startsWith$default((String)lowerRendered, (String)lowerPrefix, (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)upperRendered, (String)upperPrefix, (boolean)false, (int)2, null)) {
            String string = lowerRendered;
            int n = lowerPrefix.length();
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String lowerWithoutPrefix = string3;
            String string4 = upperRendered;
            int n2 = upperPrefix.length();
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            String upperWithoutPrefix = string6;
            String flexibleCollectionName = foldedPrefix + lowerWithoutPrefix;
            if (Intrinsics.areEqual((Object)lowerWithoutPrefix, (Object)upperWithoutPrefix)) {
                return flexibleCollectionName;
            }
            if (this.differsOnlyInNullability(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName + "!";
            }
        }
        return null;
    }

    private final boolean differsOnlyInNullability(String lower, String upper) {
        return Intrinsics.areEqual((Object)lower, (Object)StringsKt.replace$default((String)upper, (String)"?", (String)"", (boolean)false, (int)4, null)) || StringsKt.endsWith$default((String)upper, (String)"?", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)(lower + '?'), (Object)upper) || Intrinsics.areEqual((Object)('(' + lower + ")?"), (Object)upper);
    }

    private final boolean overridesSomething(CallableMemberDescriptor callable) {
        return !callable.getOverriddenDescriptors().isEmpty();
    }

    @NotNull
    public final DescriptorRendererOptionsImpl getOptions() {
        return this.options;
    }

    public DescriptorRendererImpl(@NotNull DescriptorRendererOptionsImpl options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.options = options;
        boolean bl = this.options.isLocked();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.functionTypeAnnotationsRenderer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DescriptorRendererImpl>(this){
            final /* synthetic */ DescriptorRendererImpl this$0;

            @NotNull
            public final DescriptorRendererImpl invoke() {
                DescriptorRenderer descriptorRenderer2 = this.this$0.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)functionTypeAnnotationsRenderer.1.INSTANCE));
                if (descriptorRenderer2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.renderer.DescriptorRendererImpl");
                }
                return (DescriptorRendererImpl)descriptorRenderer2;
            }
            {
                this.this$0 = descriptorRendererImpl;
                super(0);
            }
        }));
        this.functionTypeParameterTypesRenderer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DescriptorRenderer>(this){
            final /* synthetic */ DescriptorRendererImpl this$0;

            @NotNull
            public final DescriptorRenderer invoke() {
                return this.this$0.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)functionTypeParameterTypesRenderer.1.INSTANCE));
            }
            {
                this.this$0 = descriptorRendererImpl;
                super(0);
            }
        }));
    }

    public boolean getAlwaysRenderModifiers() {
        return this.options.getAlwaysRenderModifiers();
    }

    @Override
    @NotNull
    public AnnotationArgumentsRenderingPolicy getAnnotationArgumentsRenderingPolicy() {
        return this.options.getAnnotationArgumentsRenderingPolicy();
    }

    @Override
    public void setAnnotationArgumentsRenderingPolicy(@NotNull AnnotationArgumentsRenderingPolicy annotationArgumentsRenderingPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)annotationArgumentsRenderingPolicy), (String)"<set-?>");
        this.options.setAnnotationArgumentsRenderingPolicy(annotationArgumentsRenderingPolicy);
    }

    @Nullable
    public Function1<AnnotationDescriptor, Boolean> getAnnotationFilter() {
        return this.options.getAnnotationFilter();
    }

    public boolean getClassWithPrimaryConstructor() {
        return this.options.getClassWithPrimaryConstructor();
    }

    @NotNull
    public ClassifierNamePolicy getClassifierNamePolicy() {
        return this.options.getClassifierNamePolicy();
    }

    @Override
    public void setClassifierNamePolicy(@NotNull ClassifierNamePolicy classifierNamePolicy) {
        Intrinsics.checkParameterIsNotNull((Object)classifierNamePolicy, (String)"<set-?>");
        this.options.setClassifierNamePolicy(classifierNamePolicy);
    }

    @Override
    public boolean getDebugMode() {
        return this.options.getDebugMode();
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.options.setDebugMode(bl);
    }

    @Nullable
    public Function1<ValueParameterDescriptor, String> getDefaultParameterValueRenderer() {
        return this.options.getDefaultParameterValueRenderer();
    }

    @NotNull
    public Set<FqName> getExcludedAnnotationClasses() {
        return this.options.getExcludedAnnotationClasses();
    }

    @Override
    @NotNull
    public Set<FqName> getExcludedTypeAnnotationClasses() {
        return this.options.getExcludedTypeAnnotationClasses();
    }

    @Override
    public void setExcludedTypeAnnotationClasses(@NotNull Set<FqName> set) {
        Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
        this.options.setExcludedTypeAnnotationClasses(set);
    }

    public boolean getIncludeAdditionalModifiers() {
        return this.options.getIncludeAdditionalModifiers();
    }

    public boolean getIncludeAnnotationArguments() {
        return this.options.getIncludeAnnotationArguments();
    }

    public boolean getIncludeEmptyAnnotationArguments() {
        return this.options.getIncludeEmptyAnnotationArguments();
    }

    public boolean getIncludePropertyConstant() {
        return this.options.getIncludePropertyConstant();
    }

    @NotNull
    public Set<DescriptorRendererModifier> getModifiers() {
        return this.options.getModifiers();
    }

    @Override
    public void setModifiers(@NotNull Set<? extends DescriptorRendererModifier> set) {
        Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
        this.options.setModifiers(set);
    }

    public boolean getNormalizedVisibilities() {
        return this.options.getNormalizedVisibilities();
    }

    @NotNull
    public OverrideRenderingPolicy getOverrideRenderingPolicy() {
        return this.options.getOverrideRenderingPolicy();
    }

    @NotNull
    public ParameterNameRenderingPolicy getParameterNameRenderingPolicy() {
        return this.options.getParameterNameRenderingPolicy();
    }

    @Override
    public void setParameterNameRenderingPolicy(@NotNull ParameterNameRenderingPolicy parameterNameRenderingPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)parameterNameRenderingPolicy), (String)"<set-?>");
        this.options.setParameterNameRenderingPolicy(parameterNameRenderingPolicy);
    }

    public boolean getParameterNamesInFunctionalTypes() {
        return this.options.getParameterNamesInFunctionalTypes();
    }

    public boolean getReceiverAfterName() {
        return this.options.getReceiverAfterName();
    }

    @Override
    public void setReceiverAfterName(boolean bl) {
        this.options.setReceiverAfterName(bl);
    }

    public boolean getRenderAccessors() {
        return this.options.getRenderAccessors();
    }

    public boolean getRenderCompanionObjectName() {
        return this.options.getRenderCompanionObjectName();
    }

    @Override
    public void setRenderCompanionObjectName(boolean bl) {
        this.options.setRenderCompanionObjectName(bl);
    }

    public boolean getRenderConstructorKeyword() {
        return this.options.getRenderConstructorKeyword();
    }

    public boolean getRenderDefaultAnnotationArguments() {
        return this.options.getRenderDefaultAnnotationArguments();
    }

    public boolean getRenderDefaultVisibility() {
        return this.options.getRenderDefaultVisibility();
    }

    public boolean getRenderUnabbreviatedType() {
        return this.options.getRenderUnabbreviatedType();
    }

    public boolean getSecondaryConstructorsAsPrimary() {
        return this.options.getSecondaryConstructorsAsPrimary();
    }

    public boolean getStartFromDeclarationKeyword() {
        return this.options.getStartFromDeclarationKeyword();
    }

    public boolean getStartFromName() {
        return this.options.getStartFromName();
    }

    @Override
    public void setStartFromName(boolean bl) {
        this.options.setStartFromName(bl);
    }

    @NotNull
    public RenderingFormat getTextFormat() {
        return this.options.getTextFormat();
    }

    @Override
    public void setTextFormat(@NotNull RenderingFormat renderingFormat) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)renderingFormat), (String)"<set-?>");
        this.options.setTextFormat(renderingFormat);
    }

    @NotNull
    public Function1<KotlinType, KotlinType> getTypeNormalizer() {
        return this.options.getTypeNormalizer();
    }

    public boolean getUninferredTypeParameterAsName() {
        return this.options.getUninferredTypeParameterAsName();
    }

    public boolean getUnitReturnType() {
        return this.options.getUnitReturnType();
    }

    @NotNull
    public DescriptorRenderer.ValueParametersHandler getValueParametersHandler() {
        return this.options.getValueParametersHandler();
    }

    public boolean getVerbose() {
        return this.options.getVerbose();
    }

    @Override
    public void setVerbose(boolean bl) {
        this.options.setVerbose(bl);
    }

    public boolean getWithDefinedIn() {
        return this.options.getWithDefinedIn();
    }

    @Override
    public void setWithDefinedIn(boolean bl) {
        this.options.setWithDefinedIn(bl);
    }

    public boolean getWithSourceFileForTopLevel() {
        return this.options.getWithSourceFileForTopLevel();
    }

    public boolean getWithoutReturnType() {
        return this.options.getWithoutReturnType();
    }

    public boolean getWithoutSuperTypes() {
        return this.options.getWithoutSuperTypes();
    }

    @Override
    public void setWithoutSuperTypes(boolean bl) {
        this.options.setWithoutSuperTypes(bl);
    }

    public boolean getWithoutTypeParameters() {
        return this.options.getWithoutTypeParameters();
    }

    @Override
    public void setWithoutTypeParameters(boolean bl) {
        this.options.setWithoutTypeParameters(bl);
    }

    @NotNull
    public static final /* synthetic */ String access$renderConstant(DescriptorRendererImpl $this, @NotNull ConstantValue value) {
        return $this.renderConstant(value);
    }

    private final class RenderDeclarationDescriptorVisitor
    implements DeclarationDescriptorVisitor<Unit, StringBuilder> {
        @Override
        public void visitValueParameterDescriptor(@NotNull ValueParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderValueParameter(descriptor2, true, builder, true);
        }

        @Override
        public void visitPropertyDescriptor(@NotNull PropertyDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderProperty(descriptor2, builder);
        }

        @Override
        public void visitPropertyGetterDescriptor(@NotNull PropertyGetterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            if (DescriptorRendererImpl.this.getRenderAccessors()) {
                DescriptorRendererImpl.this.renderAccessorModifiers(descriptor2, builder);
                builder.append("getter for ");
                PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
                DescriptorRendererImpl.this.renderProperty(propertyDescriptor, builder);
            } else {
                this.visitFunctionDescriptor((FunctionDescriptor)descriptor2, builder);
            }
        }

        @Override
        public void visitPropertySetterDescriptor(@NotNull PropertySetterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            if (DescriptorRendererImpl.this.getRenderAccessors()) {
                DescriptorRendererImpl.this.renderAccessorModifiers(descriptor2, builder);
                builder.append("setter for ");
                PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
                DescriptorRendererImpl.this.renderProperty(propertyDescriptor, builder);
            } else {
                this.visitFunctionDescriptor((FunctionDescriptor)descriptor2, builder);
            }
        }

        @Override
        public void visitFunctionDescriptor(@NotNull FunctionDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderFunction(descriptor2, builder);
        }

        @Override
        public void visitReceiverParameterDescriptor(@NotNull ReceiverParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            builder.append(descriptor2.getName());
        }

        @Override
        public void visitConstructorDescriptor(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)constructorDescriptor, (String)"constructorDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderConstructor(constructorDescriptor, builder);
        }

        @Override
        public void visitTypeParameterDescriptor(@NotNull TypeParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderTypeParameter(descriptor2, builder, true);
        }

        @Override
        public void visitPackageFragmentDescriptor(@NotNull PackageFragmentDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderPackageFragment(descriptor2, builder);
        }

        @Override
        public void visitPackageViewDescriptor(@NotNull PackageViewDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderPackageView(descriptor2, builder);
        }

        @Override
        public void visitModuleDeclaration(@NotNull ModuleDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderName(descriptor2, builder);
        }

        @Override
        public void visitClassDescriptor(@NotNull ClassDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderClass(descriptor2, builder);
        }

        @Override
        public void visitTypeAliasDescriptor(@NotNull TypeAliasDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            DescriptorRendererImpl.this.renderTypeAlias(descriptor2, builder);
        }
    }
}

